/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.api.client.lightmap.vanilla;

import com.falsepattern.lib.util.MathUtil;
import com.falsepattern.rple.api.client.lightmap.RPLELightMapMask;
import com.falsepattern.rple.api.client.lightmap.RPLELightMapStrip;
import com.falsepattern.rple.internal.common.config.RPLEConfig;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.NotNull;

public class GammaMask
implements RPLELightMapMask {
    @Override
    public void mutateBlockLightMap(@NotNull RPLELightMapStrip output, float partialTick) {
        this.mutateLightMap(output, partialTick);
    }

    @Override
    public void mutateSkyLightMap(@NotNull RPLELightMapStrip output, float partialTick) {
        this.mutateLightMap(output, partialTick);
    }

    protected void mutateLightMap(@NotNull RPLELightMapStrip output, float partialTick) {
        boolean hd = RPLEConfig.HD.MODE != RPLEConfig.HD.Mode.Disabled;
        float gamma = hd && RPLEConfig.HD.GAMMA_OVERRIDE != -1.0 ? MathUtil.clamp((float)((float)RPLEConfig.HD.GAMMA_OVERRIDE), (float)0.0f, (float)1.0f) : MathUtil.clamp((float)Minecraft.func_71410_x().field_71474_y.field_74333_Y, (float)0.0f, (float)1.0f);
        float gammaInv = 1.0f - gamma;
        float[] R = output.lightMapRedData();
        float[] G = output.lightMapGreenData();
        float[] B = output.lightMapBlueData();
        for (int i = 0; i < 16; ++i) {
            float r = R[i];
            float g = G[i];
            float b = B[i];
            float rI = 1.0f - r;
            float gI = 1.0f - g;
            float bI = 1.0f - b;
            rI = 1.0f - rI * rI * rI * rI;
            gI = 1.0f - gI * gI * gI * gI;
            bI = 1.0f - bI * bI * bI * bI;
            r = r * gammaInv + rI * gamma;
            g = g * gammaInv + gI * gamma;
            b = b * gammaInv + bI * gamma;
            r = MathUtil.clamp((float)r, (float)0.0f, (float)1.0f);
            g = MathUtil.clamp((float)g, (float)0.0f, (float)1.0f);
            b = MathUtil.clamp((float)b, (float)0.0f, (float)1.0f);
            R[i] = r;
            G[i] = g;
            B[i] = b;
        }
    }
}

