/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.proxy;

import com.falsepattern.falsetweaks.Compat;
import com.falsepattern.falsetweaks.FalseTweaks;
import com.falsepattern.falsetweaks.Share;
import com.falsepattern.falsetweaks.config.ModuleConfig;
import com.falsepattern.falsetweaks.config.RenderDistanceConfig;
import com.falsepattern.falsetweaks.modules.beddium.BeddiumBridge;
import com.falsepattern.falsetweaks.modules.debug.Debug;
import com.falsepattern.falsetweaks.modules.dynlights.DynamicLightsDrivers;
import com.falsepattern.falsetweaks.modules.renderlists.ItemRenderListManager;
import com.falsepattern.falsetweaks.modules.renderlists.VoxelRenderListManager;
import com.falsepattern.falsetweaks.modules.threadedupdates.saftey.ThreadSafeBlockRendererMap;
import com.falsepattern.falsetweaks.modules.triangulator.calibration.Calibration;
import com.falsepattern.falsetweaks.modules.voxelizer.loading.LayerMetadataSection;
import com.falsepattern.falsetweaks.modules.voxelizer.loading.LayerMetadataSerializer;
import com.falsepattern.falsetweaks.proxy.CommonProxy;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ICrashCallable;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.data.IMetadataSectionSerializer;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.command.ICommand;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.client.ClientCommandHandler;

public class ClientProxy
extends CommonProxy {
    public static boolean clippingHelperShouldInit = true;

    @Override
    public void preInit(FMLPreInitializationEvent e) {
        super.preInit(e);
        if (Loader.isModLoaded((String)"angelica") && ModuleConfig.THREADED_CHUNK_UPDATES()) {
            FalseTweaks.createSidedException("FalseTweaks threaded rendering is not compatible with Angelica.\nPlease disable it in the FalseTweaks config.");
        }
        if (ModuleConfig.TEXTURE_OPTIMIZATIONS && Compat.isSTBIStitcher()) {
            FalseTweaks.createSidedException("FalseTweaks " + EnumChatFormatting.BOLD + "textureOptimizations" + EnumChatFormatting.RESET + " is not compatible with LWJGL3Ify's " + EnumChatFormatting.BOLD + "stbiTextureStitching" + EnumChatFormatting.RESET + " option.\nDisable stbiTextureStitching in the lwjgl3ify.cfg\nor disable textureOptimizations in FalseTweaks!");
        }
        FMLCommonHandler.instance().registerCrashCallable(new ICrashCallable(){

            public String getLabel() {
                return "FalseTweaks";
            }

            public String call() {
                StringBuilder sb = new StringBuilder();
                if (ModuleConfig.THREADED_CHUNK_UPDATES()) {
                    sb.append("Threaded chunk updates enabled");
                }
                return sb.toString();
            }
        });
        Share.LEAKFIX_CLASS_INITIALIZED = true;
        if (ModuleConfig.TRIANGULATOR) {
            Calibration.registerBus();
        }
        if (ModuleConfig.VOXELIZER) {
            Minecraft.func_71410_x().field_110452_an.func_110504_a((IMetadataSectionSerializer)new LayerMetadataSerializer(), LayerMetadataSection.class);
        }
        if (ModuleConfig.THREADED_CHUNK_UPDATES()) {
            ThreadSafeBlockRendererMap.inject();
        }
        if (Compat.beddiumInstalled()) {
            if (ModuleConfig.THREADED_CHUNK_UPDATES()) {
                BeddiumBridge.registerThreadingProvider();
            } else {
                BeddiumBridge.registerBasicProvider();
            }
        }
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @Override
    public void init(FMLInitializationEvent e) {
        super.init(e);
        if (!ModuleConfig.THREADED_CHUNK_UPDATES() || Loader.isModLoaded((String)"gtnhlib")) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.RenderTickEvent e) {
        clippingHelperShouldInit = true;
    }

    @Override
    public void postInit(FMLPostInitializationEvent e) {
        super.postInit(e);
        if (ModuleConfig.ITEM_RENDER_LISTS) {
            ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)ItemRenderListManager.INSTANCE);
            if (ModuleConfig.VOXELIZER) {
                ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)VoxelRenderListManager.INSTANCE);
            }
        }
        if (ModuleConfig.TRIANGULATOR) {
            ClientCommandHandler.instance.func_71560_a((ICommand)new Calibration.CalibrationCommand());
        }
        if (Compat.dynamicLightsPresent()) {
            DynamicLightsDrivers.postInit();
        }
        Compat.applyCompatibilityTweaks();
        if (ModuleConfig.UNLOCK_RENDER_DISTANCE && GameSettings.Options.RENDER_DISTANCE.func_148267_f() != (float)RenderDistanceConfig.RENDER_DISTANCE) {
            GameSettings.Options.RENDER_DISTANCE.func_148263_a((float)RenderDistanceConfig.RENDER_DISTANCE);
        }
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        settings.field_151451_c = Math.min(settings.field_151451_c, (int)GameSettings.Options.RENDER_DISTANCE.func_148267_f());
        if (Debug.ENABLED) {
            Debug.init();
        }
    }

    @Override
    public void loadComplete(FMLLoadCompleteEvent e) {
        super.loadComplete(e);
        ThreadSafeBlockRendererMap.logBrokenISBRHs();
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent e) {
        if (!e.modID.equals("falsetweaks")) {
            return;
        }
        if (ModuleConfig.UNLOCK_RENDER_DISTANCE) {
            GameSettings.Options.RENDER_DISTANCE.func_148263_a((float)RenderDistanceConfig.RENDER_DISTANCE);
        }
    }
}

