/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.voxelizer;

import com.falsepattern.falsetweaks.Compat;
import com.falsepattern.falsetweaks.Share;
import com.falsepattern.falsetweaks.config.ModuleConfig;
import com.falsepattern.falsetweaks.config.VoxelizerConfig;
import com.falsepattern.falsetweaks.modules.renderlists.VoxelRenderListManager;
import com.falsepattern.falsetweaks.modules.voxelizer.Data;
import com.falsepattern.falsetweaks.modules.voxelizer.VoxelMesh;
import com.falsepattern.falsetweaks.modules.voxelizer.VoxelType;
import com.falsepattern.lib.util.MathUtil;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL11;

public class VoxelRenderHelper {
    private static final TObjectIntMap<String> layers = new TObjectIntHashMap();
    private static final ThreadLocal<Matrix4f> threadMatrix = ThreadLocal.withInitial(Matrix4f::new);
    private static final float RAD_90DEG = (float)Math.toRadians(90.0);
    private static final float RAD_NEG90DEG = (float)Math.toRadians(-90.0);
    private static final float RAD_45DEG = (float)Math.toRadians(45.0);
    private static final int RAIL_FLAT_NORTH_SOUTH = 0;
    private static final int RAIL_FLAT_WEST_EAST = 1;
    private static final int RAIL_RAMP_EAST = 2;
    private static final int RAIL_RAMP_WEST = 3;
    private static final int RAIL_RAMP_NORTH = 4;
    private static final int RAIL_RAMP_SOUTH = 5;
    private static final int RAIL_CORNER_EAST_SOUTH = 6;
    private static final int RAIL_CORNER_WEST_SOUTH = 7;
    private static final int RAIL_CORNER_WEST_NORTH = 8;
    private static final int RAIL_CORNER_EAST_NORTH = 9;

    public static void renderItemVoxelized(TextureAtlasSprite iicon) {
        int layer;
        VoxelMesh mesh = VoxelMesh.getMesh(iicon);
        String name = iicon.func_94215_i();
        if (layers.containsKey((Object)name)) {
            layer = layers.get((Object)name) * 2;
            if (Data.enchantmentGlintTextureBound) {
                ++layer;
            }
        } else {
            layer = Data.getCurrentItemLayer() * 2;
            if (Data.enchantmentGlintTextureBound) {
                --layer;
            }
        }
        if (Data.enchantmentGlintTextureBound) {
            GL11.glDepthFunc((int)515);
        }
        if (ModuleConfig.ITEM_RENDER_LISTS && VoxelRenderListManager.INSTANCE.pre(mesh, layer, Data.enchantmentGlintTextureBound)) {
            return;
        }
        Tessellator tess = Compat.tessellator();
        tess.func_78382_b();
        mesh.renderToTessellator(tess, layer, Data.enchantmentGlintTextureBound, VoxelType.Solid);
        tess.func_78381_a();
        GL11.glPushAttrib((int)24576);
        if (!Data.enchantmentGlintTextureBound) {
            GL11.glEnable((int)3042);
            GL11.glEnable((int)2884);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        }
        tess.func_78382_b();
        mesh.renderToTessellator(tess, layer, Data.enchantmentGlintTextureBound, VoxelType.SemiSolid);
        tess.func_78381_a();
        GL11.glPopAttrib();
        if (ModuleConfig.ITEM_RENDER_LISTS) {
            VoxelRenderListManager.INSTANCE.post();
        }
    }

    public static void renderRail(IBlockAccess blockAccess, BlockRailBase rail, int x, int y, int z, int railDirection, IIcon iicon, boolean mirrored) {
        Tessellator tess = Compat.tessellator();
        VoxelMesh mesh = VoxelMesh.getMesh((TextureAtlasSprite)iicon);
        tess.func_78380_c(rail.func_149677_c(blockAccess, x, y, z));
        tess.func_78386_a(1.0f, 1.0f, 1.0f);
        Matrix4f transform = threadMatrix.get();
        transform.translation((float)x, (float)y, (float)z);
        transform.translate(0.5f, 0.0f, 0.5f);
        switch (railDirection) {
            case 1: 
            case 2: 
            case 7: {
                transform.rotateY(RAD_NEG90DEG);
                break;
            }
            case 5: 
            case 8: {
                transform.scale(-1.0f, 1.0f, -1.0f);
                break;
            }
            case 3: 
            case 9: {
                transform.rotateY(RAD_90DEG);
            }
        }
        if (!mirrored) {
            transform.scale(-1.0f, 1.0f, -1.0f);
        }
        transform.translate(-0.5f, 0.0f, -0.5f);
        float offset = (float)(0.0625 * VoxelizerConfig.RAIL_THICKNESS);
        switch (railDirection) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                transform.translate(0.0f, offset, 0.0f).rotateX(RAD_45DEG).scale(1.0f, MathUtil.SQRT_2, MathUtil.SQRT_2).translate(0.0f, 0.0f, offset);
                break;
            }
            default: {
                transform.rotateX(RAD_90DEG);
            }
        }
        transform.scale(1.0f, 1.0f, (float)VoxelizerConfig.RAIL_THICKNESS);
        mesh.renderToTessellator(tess, 0, false, true, (Matrix4fc)transform, face -> {
            switch (face.dir) {
                case Up: {
                    if (face.minY != 0) break;
                    switch (railDirection) {
                        case 0: {
                            return VoxelRenderHelper.isBlockRailWithDirection(blockAccess, x, y, z - 1, 0, 4, 6, 7);
                        }
                        case 1: {
                            return VoxelRenderHelper.isBlockRailWithDirection(blockAccess, x + 1, y, z, 1, 2, 7, 8);
                        }
                    }
                    break;
                }
                case Down: {
                    if (face.maxY != mesh.ySize() - 1) break;
                    switch (railDirection) {
                        case 0: {
                            return VoxelRenderHelper.isBlockRailWithDirection(blockAccess, x, y, z + 1, 0, 5, 9, 8);
                        }
                        case 1: {
                            return VoxelRenderHelper.isBlockRailWithDirection(blockAccess, x - 1, y, z, 1, 3, 6, 9);
                        }
                    }
                    break;
                }
                case Right: {
                    if (face.maxX != mesh.xSize() - 1) break;
                }
            }
            return false;
        }, VoxelType.Solid);
    }

    private static boolean isBlockRailWithDirection(IBlockAccess blockAccess, int x, int y, int z, int ... expectedRailDirection) {
        Block block = blockAccess.func_147439_a(x, y, z);
        if (!(block instanceof BlockRailBase)) {
            return false;
        }
        int railDirection = ((BlockRailBase)block).getBasicRailMetadata(blockAccess, null, x, y, z) & 0xF;
        for (int expected : expectedRailDirection) {
            if (expected != railDirection) continue;
            return true;
        }
        return false;
    }

    public static void renderRailVanilla(RenderBlocks renderBlocks, BlockRailBase rail, int x, int y, int z) {
        int railDirection = renderBlocks.field_147845_a.func_72805_g(x, y, z) & 0xF;
        IIcon iicon = renderBlocks.func_147787_a((Block)rail, 0, railDirection);
        if (renderBlocks.func_147744_b()) {
            iicon = renderBlocks.field_147840_d;
        }
        if (rail.func_150050_e()) {
            railDirection &= 7;
        }
        VoxelRenderHelper.renderRail(renderBlocks.field_147845_a, rail, x, y, z, railDirection, iicon, false);
    }

    static {
        if (VoxelizerConfig.FORCED_LAYERS == null) {
            Share.log.error("Overlay config broken.");
        }
        for (String entry : VoxelizerConfig.FORCED_LAYERS) {
            String[] parts = entry.split("=");
            if (parts.length != 2) {
                Share.log.error("Invalid forced layer " + entry + " in overlay config! Format should be: texturename=number");
                continue;
            }
            try {
                layers.put((Object)parts[0], Integer.parseInt(parts[1]));
            }
            catch (NumberFormatException e) {
                Share.log.error("Could not parse layer from " + entry + " in overlay config!", (Throwable)e);
            }
        }
    }
}

