/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.voxelizer;

import com.falsepattern.falsetweaks.modules.voxelizer.Dir;
import lombok.Generated;

public class Face
implements Cloneable {
    public final Dir dir;
    public final int z;
    public int minX;
    public int maxX;
    public int minY;
    public int maxY;
    public float u1;
    public float u2;
    public float v1;
    public float v2;
    public Face parent = null;
    public boolean used = false;

    public Face(Dir dir, int z, int minX, int maxX, int minY, int maxY, float u1, float u2, float v1, float v2) {
        this.dir = dir;
        this.z = z;
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.u1 = u1;
        this.u2 = u2;
        this.v1 = v1;
        this.v2 = v2;
    }

    public static boolean tryMerge(Face a, Face b) {
        if (a == null || b == null) {
            return false;
        }
        while (a.parent != null) {
            a = a.parent;
        }
        while (b.parent != null) {
            b = b.parent;
        }
        return a.tryMerge(b);
    }

    public boolean tryMerge(Face other) {
        if (other == null) {
            return false;
        }
        if (other.dir != this.dir || other.z != this.z) {
            return false;
        }
        if (other.minY == this.minY && other.maxY == this.maxY) {
            if (other.maxX == this.minX - 1) {
                other.maxX = this.maxX;
                other.u2 = this.u2;
                this.parent = other;
                return true;
            }
            if (this.maxX == other.minX - 1) {
                this.maxX = other.maxX;
                this.u2 = other.u2;
                other.parent = this;
                return true;
            }
        }
        if (other.minX == this.minX && other.maxX == this.maxX) {
            if (other.maxY == this.minY - 1) {
                other.maxY = this.maxY;
                other.v2 = this.v2;
                this.parent = other;
                return true;
            }
            if (this.maxY == other.minY - 1) {
                this.maxY = other.maxY;
                this.v2 = other.v2;
                other.parent = this;
                return true;
            }
        }
        return false;
    }

    public Face clone() {
        try {
            return (Face)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    @Generated
    public static FaceBuilder builder() {
        return new FaceBuilder();
    }

    @Generated
    public static class FaceBuilder {
        @Generated
        private Dir dir;
        @Generated
        private int z;
        @Generated
        private int minX;
        @Generated
        private int maxX;
        @Generated
        private int minY;
        @Generated
        private int maxY;
        @Generated
        private float u1;
        @Generated
        private float u2;
        @Generated
        private float v1;
        @Generated
        private float v2;

        @Generated
        FaceBuilder() {
        }

        @Generated
        public FaceBuilder dir(Dir dir) {
            this.dir = dir;
            return this;
        }

        @Generated
        public FaceBuilder z(int z) {
            this.z = z;
            return this;
        }

        @Generated
        public FaceBuilder minX(int minX) {
            this.minX = minX;
            return this;
        }

        @Generated
        public FaceBuilder maxX(int maxX) {
            this.maxX = maxX;
            return this;
        }

        @Generated
        public FaceBuilder minY(int minY) {
            this.minY = minY;
            return this;
        }

        @Generated
        public FaceBuilder maxY(int maxY) {
            this.maxY = maxY;
            return this;
        }

        @Generated
        public FaceBuilder u1(float u1) {
            this.u1 = u1;
            return this;
        }

        @Generated
        public FaceBuilder u2(float u2) {
            this.u2 = u2;
            return this;
        }

        @Generated
        public FaceBuilder v1(float v1) {
            this.v1 = v1;
            return this;
        }

        @Generated
        public FaceBuilder v2(float v2) {
            this.v2 = v2;
            return this;
        }

        @Generated
        public Face build() {
            return new Face(this.dir, this.z, this.minX, this.maxX, this.minY, this.maxY, this.u1, this.u2, this.v1, this.v2);
        }

        @Generated
        public String toString() {
            return "Face.FaceBuilder(dir=" + (Object)((Object)this.dir) + ", z=" + this.z + ", minX=" + this.minX + ", maxX=" + this.maxX + ", minY=" + this.minY + ", maxY=" + this.maxY + ", u1=" + this.u1 + ", u2=" + this.u2 + ", v1=" + this.v1 + ", v2=" + this.v2 + ")";
        }
    }
}

