/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.vertexapi;

import com.falsepattern.falsetweaks.Compat;
import com.ventooth.swansong.tessellator.ShaderTess;

public class VertexInfo {
    private static final int VANILLA_SIZE = 8;
    private static int SHADER_SIZE;
    private static int shaderOffset;
    private static int vanillaOffset;
    private static int extraVertexInts;
    private static boolean shaderInitialized;

    private static void initShaderCompat() {
        if (shaderInitialized) {
            return;
        }
        shaderInitialized = true;
        if (Compat.swanSongInstalled()) {
            SHADER_SIZE = 20;
            shaderOffset = 20;
        } else {
            SHADER_SIZE = 18;
            shaderOffset = 18;
        }
    }

    public static synchronized void allocateExtraVertexSlots(int count, int[] indices, int[] shaderIndices) {
        VertexInfo.initShaderCompat();
        if (count <= 0) {
            throw new IllegalArgumentException("Count must be > 0");
        }
        if (indices.length != count) {
            throw new IllegalArgumentException("indices array size must be equal to count");
        }
        if (shaderIndices.length != count) {
            throw new IllegalArgumentException("shaderIndices array size must be equal to count");
        }
        for (int i = 0; i < count; ++i) {
            ++vanillaOffset;
            ++shaderOffset;
        }
        extraVertexInts += count;
    }

    public static int recomputeVertexInfo(int currentInts, int multiplier) {
        return (currentInts + extraVertexInts) * multiplier;
    }

    public static int getVertexInfo(Compat.ShaderType type, int multiplier) {
        VertexInfo.initShaderCompat();
        switch (type) {
            case None: {
                return VertexInfo.recomputeVertexInfo(8, multiplier);
            }
            case Optifine: {
                return VertexInfo.recomputeVertexInfo(SHADER_SIZE, multiplier);
            }
            case Swansong: {
                return SwansongCompat.getVertexStrideInts(multiplier);
            }
        }
        throw new AssertionError();
    }

    static {
        vanillaOffset = 8;
        extraVertexInts = 0;
        shaderInitialized = false;
    }

    private static class SwansongCompat {
        private SwansongCompat() {
        }

        public static int getVertexStrideInts(int multiplier) {
            return ShaderTess.vertexStrideInt() * multiplier;
        }
    }
}

