/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.threadedupdates;

import com.falsepattern.falsetweaks.modules.threading.MainThreadContainer;
import com.gtnewhorizon.gtnhlib.api.CapturingTesselator;
import cpw.mods.fml.common.Loader;
import net.minecraft.client.renderer.Tessellator;

public class ThreadTessellator {
    private static final ThreadLocal<Tessellator> TESS = ThreadLocal.withInitial(Tessellator::new);
    private static final boolean GTNHLIB_PRESENT = Loader.isModLoaded((String)"gtnhlib");

    public static Tessellator getThreadTessellator() {
        if (GTNHLIB_PRESENT) {
            return GTNHLibInterop.getThreadTessellator();
        }
        return ThreadTessellator.getThreadTessellatorRaw();
    }

    private static Tessellator getThreadTessellatorRaw() {
        if (MainThreadContainer.isMainThread()) {
            return ThreadTessellator.mainThreadTessellator();
        }
        return TESS.get();
    }

    public static Tessellator mainThreadTessellator() {
        return Tessellator.field_78398_a;
    }

    public static Tessellator swapMainTessellator(Tessellator tess) {
        Tessellator old = Tessellator.field_78398_a;
        Tessellator.field_78398_a = tess;
        return old;
    }

    private static class GTNHLibInterop {
        private GTNHLibInterop() {
        }

        public static Tessellator getThreadTessellator() {
            if (CapturingTesselator.isCapturing()) {
                return CapturingTesselator.getThreadTesselator();
            }
            return ThreadTessellator.getThreadTessellatorRaw();
        }
    }
}

