/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.natives;

import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Unpacker {
    private final URL data;

    public Unpacker(URL data) {
        this.data = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] names() throws IOException {
        InputStream in = this.data.openStream();
        try {
            String[] stringArray;
            block9: {
                ZipInputStream zipIn = new ZipInputStream(in);
                try {
                    ZipEntry entry;
                    ArrayList<String> result = new ArrayList<String>();
                    while ((entry = zipIn.getNextEntry()) != null) {
                        result.add(entry.getName());
                    }
                    stringArray = result.toArray(new String[0]);
                    if (Collections.singletonList(zipIn).get(0) == null) break block9;
                }
                catch (Throwable throwable) {
                    if (Collections.singletonList(zipIn).get(0) != null) {
                        zipIn.close();
                    }
                    throw throwable;
                }
                zipIn.close();
            }
            return stringArray;
        }
        finally {
            if (Collections.singletonList(in).get(0) != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpack(String blobName, Path into) throws IOException {
        InputStream in = this.data.openStream();
        try {
            ZipInputStream zipIn = new ZipInputStream(in);
            try {
                ZipEntry entry;
                while ((entry = zipIn.getNextEntry()) != null) {
                    if (!entry.getName().equals(blobName)) continue;
                    long size = entry.getSize();
                    BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(into, new OpenOption[0]));
                    try {
                        this.copy(zipIn, output, size);
                        return;
                    }
                    finally {
                        if (Collections.singletonList(output).get(0) != null) {
                            output.close();
                        }
                    }
                }
                throw new IOException("Blob " + blobName + " not found in pak file!");
            }
            finally {
                if (Collections.singletonList(zipIn).get(0) != null) {
                    zipIn.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(in).get(0) != null) {
                in.close();
            }
        }
    }

    private void copy(InputStream input, OutputStream output, long bytes) throws IOException {
        byte[] buf = new byte[(int)Math.min(bytes, 4096L)];
        while (bytes > 0L) {
            int toRead = (int)Math.min((long)buf.length, bytes);
            int read = input.read(buf, 0, toRead);
            if (read < 0) {
                throw new EOFException();
            }
            output.write(buf, 0, read);
            bytes -= (long)read;
        }
    }
}

