/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.misc;

import com.falsepattern.falsetweaks.Compat;
import com.falsepattern.falsetweaks.config.TranslucentBlockLayersConfig;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.FloatBuffer;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import shadersmod.client.SMath;
import shadersmod.client.Shaders;

public class TranslucentBlockLayers {
    private final FloatBuffer matrixBufferIn = BufferUtils.createFloatBuffer((int)16);
    private final FloatBuffer matrixBufferOut = BufferUtils.createFloatBuffer((int)16);
    private final Matrix4f matrixA = new Matrix4f();
    private final Matrix4f matrixB = new Matrix4f();

    public void offsetProjection() {
        FloatBuffer bufIn = this.matrixBufferIn;
        FloatBuffer bufOut = this.matrixBufferOut;
        int lastMatrixMode = GL11.glGetInteger((int)2976);
        GL11.glMatrixMode((int)5889);
        bufIn.position(0);
        GL11.glGetFloat((int)2983, (FloatBuffer)bufIn);
        this.transform();
        GL11.glPushMatrix();
        bufOut.position(0);
        GL11.glLoadMatrix((FloatBuffer)bufOut);
        GL11.glMatrixMode((int)lastMatrixMode);
        if (Compat.shaderType() == Compat.ShaderType.Optifine) {
            ShadersCompat.fetchFromShaders(bufIn);
            this.transform();
            ShadersCompat.setToShaders(bufOut);
        }
    }

    private void transform() {
        Matrix4f matA = this.matrixA;
        Matrix4f matB = this.matrixB;
        matB.set(0, this.matrixBufferIn);
        float epsilon = (float)(-TranslucentBlockLayersConfig.TRANSLUCENT_BLOCK_LAYERS_FIX_EPSILON);
        matA.scaling(1.0f, 1.0f, 1.0f / (1.0f + epsilon));
        matA.translate(0.0f, 0.0f, epsilon);
        matA.mul((Matrix4fc)matB);
        matA.get(0, this.matrixBufferOut);
    }

    public void resetProjection() {
        int lastMatrixMode = GL11.glGetInteger((int)2976);
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)lastMatrixMode);
        if (Compat.shaderType() == Compat.ShaderType.Optifine) {
            ShadersCompat.setToShaders(this.matrixBufferIn);
        }
    }

    private static class ShadersCompat {
        private static final FloatBuffer projection;
        private static final FloatBuffer projectionInverse;
        private static final float[] faProjection;
        private static final float[] faProjectionInverse;
        private static final Method invertMat4FBFA;

        private ShadersCompat() {
        }

        private static void fetchFromShaders(FloatBuffer buf) {
            buf.position(0);
            projection.position(0);
            buf.put(projection);
            buf.position(0);
            projection.position(0);
        }

        private static void setToShaders(FloatBuffer buf) {
            buf.position(0);
            projection.position(0);
            projection.put(buf);
            buf.position(0);
            projection.position(0);
            try {
                invertMat4FBFA.invoke(null, (FloatBuffer)projectionInverse.position(0), (FloatBuffer)projection.position(0), faProjectionInverse, faProjection);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            Shaders.setProgramUniformMatrix4ARB((String)"gbufferProjection", (boolean)false, (FloatBuffer)projection);
            Shaders.setProgramUniformMatrix4ARB((String)"gbufferProjectionInverse", (boolean)false, (FloatBuffer)projectionInverse);
        }

        static {
            try {
                Field fProjection = Shaders.class.getDeclaredField("projection");
                Field fProjectionInverse = Shaders.class.getDeclaredField("projectionInverse");
                Field ffaProjection = Shaders.class.getDeclaredField("faProjection");
                Field ffaProjectionInverse = Shaders.class.getDeclaredField("faProjectionInverse");
                invertMat4FBFA = SMath.class.getDeclaredMethod("invertMat4FBFA", FloatBuffer.class, FloatBuffer.class, float[].class, float[].class);
                invertMat4FBFA.setAccessible(true);
                fProjection.setAccessible(true);
                fProjectionInverse.setAccessible(true);
                ffaProjection.setAccessible(true);
                ffaProjectionInverse.setAccessible(true);
                projection = (FloatBuffer)fProjection.get(null);
                projectionInverse = (FloatBuffer)fProjectionInverse.get(null);
                faProjection = (float[])ffaProjection.get(null);
                faProjectionInverse = (float[])ffaProjectionInverse.get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

