/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.bsp.sorting.midpoint;

import com.falsepattern.falsetweaks.modules.bsp.sorting.SharedMath;
import com.falsepattern.falsetweaks.modules.bsp.sorting.midpoint.MidpointComputer;
import org.joml.Vector3f;

public class TriangleMidpointComputer
implements MidpointComputer {
    public static final TriangleMidpointComputer INSTANCE = new TriangleMidpointComputer();

    @Override
    public void getMidpoint(int[] vertexData, int i, int vertexSize, Vector3f output) {
        float ax = Float.intBitsToFloat(vertexData[i]);
        float ay = Float.intBitsToFloat(vertexData[i + 1]);
        float az = Float.intBitsToFloat(vertexData[i + 2]);
        float bx = Float.intBitsToFloat(vertexData[i + vertexSize]);
        float by = Float.intBitsToFloat(vertexData[i + vertexSize + 1]);
        float bz = Float.intBitsToFloat(vertexData[i + vertexSize + 2]);
        float cx = Float.intBitsToFloat(vertexData[i + vertexSize * 2]);
        float cy = Float.intBitsToFloat(vertexData[i + vertexSize * 2 + 1]);
        float cz = Float.intBitsToFloat(vertexData[i + vertexSize * 2 + 2]);
        float xMin = Math.min(Math.min(ax, bx), cx);
        float yMin = Math.min(Math.min(ay, by), cy);
        float zMin = Math.min(Math.min(az, bz), cz);
        float xMax = Math.max(Math.max(ax, bx), cx);
        float yMax = Math.max(Math.max(ay, by), cy);
        float zMax = Math.max(Math.max(az, bz), cz);
        SharedMath.getMidpoint(xMin, yMin, zMin, xMax, yMax, zMax, output);
    }
}

