/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.bsp.sorting;

import com.falsepattern.falsetweaks.Compat;
import com.falsepattern.falsetweaks.modules.bsp.sorting.area.NormalAreaComputer;
import com.falsepattern.falsetweaks.modules.bsp.sorting.area.QuadAreaComputer;
import com.falsepattern.falsetweaks.modules.bsp.sorting.area.TriangleAreaComputer;
import com.falsepattern.falsetweaks.modules.bsp.sorting.midpoint.MidpointComputer;
import com.falsepattern.falsetweaks.modules.bsp.sorting.midpoint.QuadMidpointComputer;
import com.falsepattern.falsetweaks.modules.bsp.sorting.midpoint.TriangleMidpointComputer;
import com.falsepattern.falsetweaks.modules.vertexapi.VertexInfo;
import lombok.Generated;
import org.joml.Vector3f;

public class PolygonHolder {
    public final int vertexStride;
    private final int polygonSize;
    private final int vertexSize;
    private final MidpointComputer midpointComputer;
    private final NormalAreaComputer areaComputer;
    private int[] vertexData;
    private int polygonCount = 0;

    public PolygonHolder(boolean triangleMode, Compat.ShaderType shaderType) {
        this.polygonSize = triangleMode ? 3 : 4;
        this.vertexSize = VertexInfo.getVertexInfo(shaderType, 1);
        this.midpointComputer = triangleMode ? TriangleMidpointComputer.INSTANCE : QuadMidpointComputer.INSTANCE;
        this.areaComputer = triangleMode ? TriangleAreaComputer.INSTANCE : QuadAreaComputer.INSTANCE;
        this.vertexStride = this.polygonSize * this.vertexSize;
    }

    public void setVertexData(int[] vertexData) {
        this.vertexData = vertexData;
        this.polygonCount = vertexData.length / this.vertexSize / this.polygonSize;
    }

    public void clearVertexData() {
        this.vertexData = null;
    }

    public void midpoint(int polygon, Vector3f output) {
        this.midpointComputer.getMidpoint(this.vertexData, polygon * this.vertexStride, this.vertexSize, output);
    }

    public float area(int polygon, Vector3f scratchBuffer) {
        return this.areaComputer.getArea(this.vertexData, polygon * this.vertexStride, this.vertexSize, scratchBuffer);
    }

    public void normal(int polygon, Vector3f output) {
        this.areaComputer.getNormal(this.vertexData, polygon * this.vertexStride, this.vertexSize, output);
    }

    @Generated
    public int[] getVertexData() {
        return this.vertexData;
    }

    @Generated
    public int getPolygonCount() {
        return this.polygonCount;
    }
}

