/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.beddium;

import com.falsepattern.falsetweaks.api.PassTrackingTessellator;
import com.falsepattern.falsetweaks.config.ModuleConfig;
import com.falsepattern.falsetweaks.modules.beddium.ChunkCacheBediumDynLights;
import com.falsepattern.falsetweaks.modules.threadedupdates.ThreadTessellator;
import com.falsepattern.falsetweaks.modules.threadedupdates.ThreadedUpdateHooks;
import com.falsepattern.falsetweaks.modules.threadedupdates.saftey.ThreadedBlockSafetyRegistry;
import com.ventooth.beddium.api.task.SimpleChunkBuilderMeshingTask;
import com.ventooth.beddium.api.task.WorldRenderRegion;
import it.unimi.dsi.fastutil.ints.IntList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import org.embeddedt.embeddium.impl.render.chunk.RenderSection;
import org.embeddedt.embeddium.impl.util.task.CancellationToken;
import org.joml.Vector3d;

public abstract class FTChunkBuilderMeshingTask
extends SimpleChunkBuilderMeshingTask {
    public FTChunkBuilderMeshingTask(RenderSection render, int time, Vector3d camera) {
        super(render, WorldRenderRegion.forChunkAt((RenderSection)render), time, camera);
    }

    protected ChunkCache createChunkCache(WorldRenderRegion worldRenderRegion) {
        return new ChunkCacheBediumDynLights((World)Minecraft.func_71410_x().field_71441_e, worldRenderRegion);
    }

    protected void setTriangulatorRenderPass(int pass) {
        if (ModuleConfig.TRIANGULATOR) {
            ((PassTrackingTessellator)this.getTessellator()).pass(pass);
        }
    }

    public static final class Threaded
    extends FTChunkBuilderMeshingTask {
        public Threaded(RenderSection render, int time, Vector3d camera) {
            super(render, time, camera);
        }

        protected Tessellator getTessellator() {
            return ThreadTessellator.getThreadTessellator();
        }

        protected void setRenderPass(int pass) {
            ThreadedUpdateHooks.setWorldRenderPass(pass);
            this.setTriangulatorRenderPass(pass);
        }

        protected boolean isThreaded() {
            return true;
        }

        protected boolean canRenderOffThread(int pass, Block block, int x, int y, int z) {
            int rt = block.func_149645_b();
            if (rt < 42) {
                return true;
            }
            return ThreadedBlockSafetyRegistry.canBlockRenderOffThread(block);
        }

        protected SimpleChunkBuilderMeshingTask.MainThreadWork createMainThreadWork(int pass, IntList coords, Tessellator tessellator, RenderBlocks renderBlocks, CancellationToken cancellationToken) {
            return new FTMainThreadWork(pass, coords, cancellationToken, tessellator, renderBlocks);
        }

        protected class FTMainThreadWork
        extends SimpleChunkBuilderMeshingTask.MainThreadWork {
            public FTMainThreadWork(int pass, IntList coords, CancellationToken cancellationToken, Tessellator tessellator, RenderBlocks renderBlocks) {
                super((SimpleChunkBuilderMeshingTask)Threaded.this, pass, coords, cancellationToken, tessellator, renderBlocks);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Tessellator oldTess = ThreadTessellator.swapMainTessellator(this.tessellator);
                int oldPass = ForgeHooksClient.getWorldRenderPass();
                Threaded.setForgeRenderPass((int)this.pass);
                try {
                    super.run();
                }
                finally {
                    Threaded.setForgeRenderPass((int)oldPass);
                    Tessellator restored = ThreadTessellator.swapMainTessellator(oldTess);
                    assert (this.tessellator == restored);
                }
            }
        }
    }

    public static final class Basic
    extends FTChunkBuilderMeshingTask {
        public Basic(RenderSection render, int time, Vector3d camera) {
            super(render, time, camera);
        }

        protected Tessellator getTessellator() {
            return ThreadTessellator.mainThreadTessellator();
        }

        protected void setRenderPass(int pass) {
            SimpleChunkBuilderMeshingTask.setForgeRenderPass((int)pass);
            this.setTriangulatorRenderPass(pass);
        }
    }
}

