/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.animfix.stitching.packing2d;

import com.falsepattern.falsetweaks.modules.animfix.stitching.Rect2D;
import com.falsepattern.falsetweaks.modules.animfix.stitching.packing2d.Algorithm;
import com.falsepattern.falsetweaks.modules.animfix.stitching.packing2d.PackerBFDH;
import com.falsepattern.falsetweaks.modules.animfix.stitching.packing2d.PackerFFDH;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public abstract class Packer<T extends Rect2D> {
    final int stripWidth;
    final List<T> rectangles;

    Packer(int stripWidth, List<T> rectangles) {
        this.stripWidth = stripWidth;
        this.rectangles = rectangles;
    }

    public static <U extends Rect2D> List<U> pack(List<U> rectangles, Algorithm algorithm, int stripWidth) {
        PackerBFDH<U> packer;
        switch (algorithm) {
            case FIRST_FIT_DECREASING_HEIGHT: {
                PackerFFDH<U> packer2 = new PackerFFDH<U>(stripWidth, rectangles);
                return ((Packer)packer2).pack();
            }
            case BEST_FIT_DECREASING_HEIGHT: {
                packer = new PackerBFDH<U>(stripWidth, rectangles);
                break;
            }
            default: {
                return new ArrayList();
            }
        }
        return ((Packer)packer).pack();
    }

    public abstract List<T> pack();

    void sortByNonIncreasingHeight(List<T> rectangles) {
        rectangles.sort(Comparator.comparingInt(rect -> rect.height).reversed());
    }
}

