/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.mixin.mixins.client.voxelizer;

import com.falsepattern.falsetweaks.Share;
import com.falsepattern.falsetweaks.config.VoxelizerConfig;
import com.falsepattern.falsetweaks.modules.voxelizer.Layer;
import com.falsepattern.falsetweaks.modules.voxelizer.interfaces.ITextureAtlasSpriteMixin;
import com.falsepattern.falsetweaks.modules.voxelizer.loading.LayerMetadataSection;
import cpw.mods.fml.client.FMLClientHandler;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TextureMap.class})
public abstract class TextureMapMixin {
    private static final float BASE_THICKNESS = 0.0625f;
    @Shadow
    @Final
    private Map<String, TextureAtlasSprite> field_110574_e;

    @Shadow
    protected abstract ResourceLocation func_147634_a(ResourceLocation var1, int var2);

    @Shadow
    public abstract IIcon func_94245_a(String var1);

    @Inject(method={"loadTextureAtlas"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/texture/TextureMap;registerIcons()V", shift=At.Shift.AFTER)}, require=1)
    private void loadExtraTexturesForLayers(IResourceManager manager, CallbackInfo ci) {
        HashMap<String, TextureAtlasSprite> sprites = new HashMap<String, TextureAtlasSprite>(this.field_110574_e);
        for (Map.Entry<String, TextureAtlasSprite> sprite : sprites.entrySet()) {
            String name = sprite.getKey();
            TextureAtlasSprite iicon = sprite.getValue();
            ITextureAtlasSpriteMixin tex = (ITextureAtlasSpriteMixin)iicon;
            ResourceLocation loc = new ResourceLocation(name);
            ResourceLocation complete = this.func_147634_a(loc, 0);
            if (iicon.hasCustomLoader(manager, complete)) continue;
            try {
                IResource resource = manager.func_110536_a(complete);
                LayerMetadataSection layerMeta = (LayerMetadataSection)resource.func_110526_a("voxelLayers");
                if (VoxelizerConfig.VERBOSE_LOG) {
                    Share.log.info("__VOXELIZER__ " + name);
                }
                if (layerMeta != null) {
                    float[] thicknesses = layerMeta.thicknesses();
                    Layer[] layers = new Layer[thicknesses.length];
                    if (VoxelizerConfig.VERBOSE_LOG) {
                        Share.log.info("__VOXELIZER__ FOUND LAYERS!");
                        Share.log.info("__VOXELIZER__ Layer count: " + thicknesses.length);
                    }
                    for (int i = 0; i < thicknesses.length; ++i) {
                        layers[thicknesses.length - 1 - i] = new Layer((TextureAtlasSprite)this.func_94245_a(name + "_" + i), thicknesses[i] * 0.0625f);
                        this.func_94245_a(name + "_" + i);
                    }
                    tex.layers(layers);
                    continue;
                }
                if (VoxelizerConfig.VERBOSE_LOG) {
                    Share.log.info("__VOXELIZER__ NO LAYERS!");
                }
                tex.layers(new Layer(iicon, 0.0625f));
            }
            catch (RuntimeException runtimeexception) {
                FMLClientHandler.instance().trackBrokenTexture(complete, runtimeexception.getMessage());
            }
            catch (IOException ioexception1) {
                FMLClientHandler.instance().trackMissingTexture(complete);
            }
        }
    }
}

