/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.config;

import com.falsepattern.falsetweaks.modules.voxelizer.strategy.StrategyPreset;
import com.falsepattern.lib.config.Config;
import com.falsepattern.lib.config.ConfigurationManager;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.launchwrapper.Launch;

@Config.Comment(value={"Options for the FalseTweaks 3D item renderer framework"})
@Config(modid="falsetweaks", category="voxelizer")
@Config.LangKey
@Config.RequiresMcRestart
public class VoxelizerConfig {
    @Config.Ignore
    private static final Set<String> knownExcludes = new HashSet<String>();
    @Config.Ignore
    private static final Set<String> knownIncludes = new HashSet<String>();
    @Config.Ignore
    private static final Set<Class<?>> knownClassExcludes = new HashSet();
    @Config.Ignore
    private static final Set<Class<?>> knownClassIncludes = new HashSet();
    @Config.Comment(value={"You can use this property to fix any incorrectly detected overlays.", "Syntax: texture_name=layer, where layer is the multiplier.", "The default behaviour is that if the texture name ends with _overlay, its layer is set to 1,", "This can be used to override that.", "For reference: layer 0 is regular rendering, layer 1 is on top layer 0, layer 2 is on top of layer 1, etc.", "Also supports negatives, but going below -1 is undefined behaviour. (-1 is used for the liquid inside potions by default)"})
    @Config.LangKey
    @Config.Name(value="forcedLayers", migrations={""})
    @Config.DefaultStringList(value={"potion_overlay=-1"})
    public static String[] FORCED_LAYERS;
    @Config.Comment(value={"The merging strategy preset to use for the voxelized mesh optimization.", "Set this higher if you have a strong cpu and weak gpu, and set this lower if you have a weak cpu and strong gpu.", "FPS impact: Depends on setup."})
    @Config.LangKey
    @Config.Name(value="optimizationStrategy", migrations={""})
    @Config.DefaultEnum(value="Best_2")
    public static StrategyPreset MESH_OPTIMIZATION_STRATEGY_PRESET;
    @Config.Comment(value={"Makes rails 3-dimensional. Doesn't require game restart.", "FPS impact: basically none"})
    @Config.LangKey
    @Config.Name(value="rails3D", migrations={""})
    @Config.DefaultBoolean(value=true)
    public static boolean RAILS_3D;
    @Config.Comment(value={"If set to true, the mesh compiler will print out detailed information when textures are compiled", "into meshes."})
    @Config.LangKey
    @Config.Name(value="debugMeshCompilation", migrations={""})
    @Config.DefaultBoolean(value=false)
    public static boolean DEBUG_MESH_COMPILATION;
    @Config.Comment(value={"Item textures to disable voxelization for. Used to fix issues with certain items.", "This is a PREFIX check, so you can also just specify a mod ID, and all items from it will skip getting voxelized.", "Needs a game restart to apply changes (cached for performance).", "Syntax: modid:texturename"})
    @Config.LangKey
    @Config.Name(value="exclusionList", migrations={""})
    @Config.DefaultStringList(value={"avaritia:infinity"})
    public static String[] EXCLUSION_LIST;
    @Config.Comment(value={"Classes to disable voxelization for. Used to fix issues with certain items.", "This is an instanceof check, so superclasses are also checked.", "Needs a game restart to apply changes (cached for performance)."})
    @Config.LangKey
    @Config.Name(value="classExclusionList", migrations={""})
    @Config.DefaultStringList(value={"cofh.lib.render.IFluidOverlayItem"})
    public static String[] CLASS_EXCLUSION_LIST;
    @Config.Comment(value={"The thickness of the 3D rails. Doesn't require game restart. 1 is vanilla thickness.", "FPS impact: basically none"})
    @Config.LangKey
    @Config.Name(value="railThickness", migrations={""})
    @Config.DefaultDouble(value=1.0)
    public static double RAIL_THICKNESS;
    @Config.Comment(value={"Extremely verbose debug logging. This will spam your log.", "Only useful on resource pack reloads."})
    @Config.LangKey
    @Config.Name(value="verboseLog", migrations={""})
    @Config.DefaultBoolean(value=false)
    public static boolean VERBOSE_LOG;

    public static boolean isExcluded(String textureName) {
        if (knownExcludes.contains(textureName)) {
            return true;
        }
        if (knownIncludes.contains(textureName)) {
            return false;
        }
        for (String s : EXCLUSION_LIST) {
            if (!textureName.startsWith(s)) continue;
            knownExcludes.add(textureName);
            return true;
        }
        knownIncludes.add(textureName);
        return false;
    }

    public static boolean isClassExcluded(Class<?> clazz) {
        if (knownClassExcludes.contains(clazz)) {
            return true;
        }
        if (knownClassIncludes.contains(clazz)) {
            return false;
        }
        for (String s : CLASS_EXCLUSION_LIST) {
            try {
                Class<?> excluded;
                if (Launch.classLoader.getClassBytes(s) == null || !(excluded = Class.forName(s)).isAssignableFrom(clazz)) continue;
                knownClassExcludes.add(clazz);
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        knownClassIncludes.add(clazz);
        return false;
    }

    public static void init() {
    }

    static {
        ConfigurationManager.selfInit();
    }
}

