/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.util.suppliers;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class ExpiringSupplier<T>
implements Supplier<T> {
    private final Supplier<@NotNull T> supplier;
    private final long expiryTime;
    private long lastTime;
    private T lastValue;

    public ExpiringSupplier(Supplier<@NotNull T> supplier, long duration, TimeUnit unit) {
        this.supplier = supplier;
        this.expiryTime = TimeUnit.NANOSECONDS.convert(duration, unit);
    }

    @Override
    public T get() {
        if (this.lastValue == null || System.nanoTime() - this.lastTime >= this.expiryTime) {
            this.lastValue = this.supplier.get();
            Objects.requireNonNull(this.lastValue, "Returned value may not be null");
            this.lastTime = System.nanoTime();
        }
        return this.lastValue;
    }
}

