/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.util.sorting;

import org.embeddedt.embeddium.impl.util.sorting.AbstractSort;
import org.embeddedt.embeddium.impl.util.sorting.InsertionSort;

public class MergeSort
extends AbstractSort {
    private static final int INSERTION_SORT_THRESHOLD = 16;

    public static int[] mergeSort(float[] keys) {
        int[] indices = MergeSort.createIndexBuffer(keys.length);
        MergeSort.mergeSort(indices, keys);
        return indices;
    }

    public static void mergeSort(int[] indices, float[] keys) {
        MergeSort.mergeSort(indices, keys, 0, indices.length, null);
    }

    private static void mergeSort(int[] indices, float[] keys, int fromIndex, int toIndex, int[] supp) {
        int len = toIndex - fromIndex;
        if (len < 16) {
            InsertionSort.insertionSort(indices, fromIndex, toIndex, keys);
            return;
        }
        if (supp == null) {
            supp = (int[])indices.clone();
        }
        int mid = fromIndex + toIndex >>> 1;
        MergeSort.mergeSort(supp, keys, fromIndex, mid, indices);
        MergeSort.mergeSort(supp, keys, mid, toIndex, indices);
        if (keys[supp[mid]] <= keys[supp[mid - 1]]) {
            System.arraycopy(supp, fromIndex, indices, fromIndex, len);
            return;
        }
        int p = fromIndex;
        int q = mid;
        for (int i = fromIndex; i < toIndex; ++i) {
            indices[i] = q >= toIndex || p < mid && keys[supp[q]] <= keys[supp[p]] ? supp[p++] : supp[q++];
        }
    }
}

