/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.util.collections.quadtree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.embeddedt.embeddium.impl.util.collections.quadtree.Rect2i;

public final class QuadTree<T>
extends Rect2i {
    private static final QuadTree<?> EMPTY = new QuadTree(new Rect2i(0, 0, 0, 0), 0, List.of(), null);
    private static final int MAX_DEPTH = 12;
    private QuadTree<T> child0;
    private QuadTree<T> child1;
    private QuadTree<T> child2;
    private QuadTree<T> child3;
    private List<Entry<T>> entries = null;

    public static <T> QuadTree<T> empty() {
        return EMPTY;
    }

    public QuadTree(Rect2i rect, int minSize, Collection<T> contents, Function<T, Rect2i> sizeFactory) {
        this(rect, minSize, 0);
        if (!contents.isEmpty()) {
            Objects.requireNonNull(sizeFactory);
            contents.forEach(c -> this.insert(c, (Rect2i)sizeFactory.apply(c)));
            this.bake();
        }
    }

    private QuadTree(Rect2i rect, int minSize, int depth) {
        super(rect);
        if (++depth < 12 && rect.width() > minSize && rect.width() % 2 == 0) {
            int childWidth = rect.width() / 2;
            int childHeight = rect.height() / 2;
            if (rect.width() == rect.height() / 2) {
                this.child0 = new QuadTree<T>(new Rect2i(rect.x(), rect.y(), rect.width(), childHeight), minSize, depth);
                this.child1 = null;
                this.child2 = null;
                this.child3 = new QuadTree<T>(new Rect2i(rect.x(), rect.y() + childHeight, rect.width(), childHeight), minSize, depth);
            } else if (rect.height() == rect.width() / 2) {
                this.child0 = new QuadTree<T>(new Rect2i(rect.x(), rect.y(), childWidth, rect.height()), minSize, depth);
                this.child1 = new QuadTree<T>(new Rect2i(rect.x() + childWidth, rect.y(), childWidth, rect.height()), minSize, depth);
                this.child2 = null;
                this.child3 = null;
            } else {
                this.child0 = new QuadTree<T>(new Rect2i(rect.x(), rect.y(), childWidth, childHeight), minSize, depth);
                this.child1 = new QuadTree<T>(new Rect2i(rect.x() + childWidth, rect.y(), childWidth, childHeight), minSize, depth);
                this.child2 = new QuadTree<T>(new Rect2i(rect.x() + childWidth, rect.y() + childHeight, childWidth, childHeight), minSize, depth);
                this.child3 = new QuadTree<T>(new Rect2i(rect.x(), rect.y() + childHeight, childWidth, childHeight), minSize, depth);
            }
        } else {
            this.child0 = null;
            this.child1 = null;
            this.child2 = null;
            this.child3 = null;
        }
    }

    private void bake() {
        if (this.entries != null) {
            this.entries = List.copyOf(this.entries);
        }
        if (this.child0 != null) {
            this.child0.bake();
            if (this.child0.isEmpty()) {
                this.child0 = null;
            }
        }
        if (this.child1 != null) {
            this.child1.bake();
            if (this.child1.isEmpty()) {
                this.child1 = null;
            }
        }
        if (this.child2 != null) {
            this.child2.bake();
            if (this.child2.isEmpty()) {
                this.child2 = null;
            }
        }
        if (this.child3 != null) {
            this.child3.bake();
            if (this.child3.isEmpty()) {
                this.child3 = null;
            }
        }
    }

    private boolean isEmpty() {
        return this.entries == null && this.child0 == null && this.child1 == null && this.child2 == null && this.child3 == null;
    }

    private boolean tryChildInsert(QuadTree<T> child, T item, Rect2i size) {
        if (child != null && child.contains(size)) {
            child.insert(item, size);
            return true;
        }
        return false;
    }

    private void insert(T item, Rect2i size) {
        if (this.tryChildInsert(this.child0, item, size)) {
            return;
        }
        if (this.tryChildInsert(this.child1, item, size)) {
            return;
        }
        if (this.tryChildInsert(this.child2, item, size)) {
            return;
        }
        if (this.tryChildInsert(this.child3, item, size)) {
            return;
        }
        if (this.entries == null) {
            this.entries = new ArrayList<Entry<T>>();
        }
        this.entries.add(new Entry<T>(size, item));
    }

    public T find(int x, int y) {
        if (!this.contains(x, y)) {
            return null;
        }
        if (this.entries != null) {
            for (Entry<T> e : this.entries) {
                if (!e.contains(x, y)) continue;
                return e.item;
            }
        }
        if (this.child0 != null && this.child0.contains(x, y)) {
            return this.child0.find(x, y);
        }
        if (this.child1 != null && this.child1.contains(x, y)) {
            return this.child1.find(x, y);
        }
        if (this.child2 != null && this.child2.contains(x, y)) {
            return this.child2.find(x, y);
        }
        if (this.child3 != null && this.child3.contains(x, y)) {
            return this.child3.find(x, y);
        }
        return null;
    }

    private static class Entry<T>
    extends Rect2i {
        final T item;

        public Entry(Rect2i size, T item) {
            super(size);
            this.item = item;
        }
    }
}

