/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.util;

import org.embeddedt.embeddium.impl.common.util.MathUtil;

public class PositionUtil {
    private static final int SIZE_BITS_X = 26;
    private static final int SIZE_BITS_Z = 26;
    private static final int SIZE_BITS_Y = 12;
    private static final long BITS_X = 0x3FFFFFFL;
    private static final long BITS_Y = 4095L;
    private static final long BITS_Z = 0x3FFFFFFL;
    private static final int BIT_SHIFT_X = 38;
    private static final int BIT_SHIFT_Z = 12;
    private static final int BIT_SHIFT_Y = 0;
    private static final long MAX_UNSIGNED_32BIT_INT = 0xFFFFFFFFL;
    private static final long SECTION_XZ_MASK = 0x3FFFFFL;
    private static final long SECTION_Y_MASK = 1048575L;

    public static long packBlock(int x, int y, int z) {
        long l = 0L;
        l |= ((long)x & 0x3FFFFFFL) << 38;
        l |= ((long)y & 0xFFFL) << 0;
        return l |= ((long)z & 0x3FFFFFFL) << 12;
    }

    public static int unpackBlockX(long packed) {
        return (int)(packed << 0 >> 38);
    }

    public static int unpackBlockY(long packed) {
        return (int)(packed << 52 >> 52);
    }

    public static int unpackBlockZ(long packed) {
        return (int)(packed << 26 >> 38);
    }

    public static long packChunk(int x, int z) {
        return ((long)z & 0xFFFFFFFFL) << 32 | (long)x & 0xFFFFFFFFL;
    }

    public static int unpackChunkX(long key) {
        return (int)(key & 0xFFFFFFFFL);
    }

    public static int unpackChunkZ(long key) {
        return (int)(key >>> 32 & 0xFFFFFFFFL);
    }

    public static long packSection(int x, int y, int z) {
        return ((long)x & 0x3FFFFFL) << 42 | ((long)y & 0xFFFFFL) << 0 | ((long)z & 0x3FFFFFL) << 20;
    }

    public static int posToSectionCoord(double coord) {
        return PositionUtil.posToSectionCoord(MathUtil.mojfloor(coord));
    }

    public static int posToSectionCoord(int coord) {
        return coord >> 4;
    }

    public static int sectionToBlockCoord(int sec, int block) {
        return (sec << 4) + block;
    }
}

