/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.sprite;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.List;
import java.util.function.Consumer;
import org.embeddedt.embeddium.impl.render.chunk.RenderSection;
import org.embeddedt.embeddium.impl.render.chunk.data.BuiltRenderSectionData;
import org.embeddedt.embeddium.impl.render.chunk.data.MinecraftBuiltRenderSectionData;
import org.embeddedt.embeddium.impl.render.chunk.lists.ChunkRenderList;
import org.embeddedt.embeddium.impl.render.chunk.lists.SectionTicker;
import org.embeddedt.embeddium.impl.render.chunk.region.RenderRegion;
import org.embeddedt.embeddium.impl.util.iterator.ByteIterator;

public class GenericSectionSpriteTicker<T>
implements SectionTicker {
    private volatile ReferenceOpenHashSet<T> sprites = new ReferenceOpenHashSet();
    private final Consumer<T> markActive;

    public GenericSectionSpriteTicker(Consumer<T> markActive) {
        this.markActive = markActive;
    }

    @Override
    public void tickVisibleRenders() {
        this.sprites.forEach(this.markActive);
    }

    @Override
    public String getDebugString() {
        return "A: " + this.sprites.size();
    }

    @Override
    public void onRenderListUpdated(List<ChunkRenderList> renderLists) {
        ReferenceOpenHashSet spriteSet = new ReferenceOpenHashSet(this.sprites.size());
        for (ChunkRenderList renderList : renderLists) {
            RenderRegion region = renderList.getRegion();
            ByteIterator iterator = renderList.sectionsWithSpritesIterator();
            if (iterator == null) continue;
            while (iterator.hasNext()) {
                BuiltRenderSectionData context;
                RenderSection section = region.getSection(iterator.nextByteAsInt());
                if (section == null || !((context = section.getBuiltContext()) instanceof MinecraftBuiltRenderSectionData)) continue;
                MinecraftBuiltRenderSectionData mcData = (MinecraftBuiltRenderSectionData)context;
                List sprites = (List)mcData.animatedSprites;
                for (int i = 0; i < sprites.size(); ++i) {
                    spriteSet.add(sprites.get(i));
                }
            }
        }
        this.sprites = spriteSet;
    }
}

