/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.region;

import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterable;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.embeddedt.embeddium.impl.gl.arena.GlBufferArena;
import org.embeddedt.embeddium.impl.gl.arena.GlBufferSegment;
import org.embeddedt.embeddium.impl.gl.arena.PendingUpload;
import org.embeddedt.embeddium.impl.gl.arena.staging.FallbackStagingBuffer;
import org.embeddedt.embeddium.impl.gl.arena.staging.MappedStagingBuffer;
import org.embeddedt.embeddium.impl.gl.arena.staging.StagingBuffer;
import org.embeddedt.embeddium.impl.gl.attribute.GlVertexFormat;
import org.embeddedt.embeddium.impl.gl.device.CommandList;
import org.embeddedt.embeddium.impl.gl.device.RenderDevice;
import org.embeddedt.embeddium.impl.render.chunk.RenderPassConfiguration;
import org.embeddedt.embeddium.impl.render.chunk.RenderSection;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkBuildOutput;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkSortOutput;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkTaskOutput;
import org.embeddedt.embeddium.impl.render.chunk.compile.executor.ChunkJobResult;
import org.embeddedt.embeddium.impl.render.chunk.data.BuiltSectionMeshParts;
import org.embeddedt.embeddium.impl.render.chunk.data.SectionRenderDataStorage;
import org.embeddedt.embeddium.impl.render.chunk.region.RenderRegion;
import org.embeddedt.embeddium.impl.render.chunk.terrain.TerrainRenderPass;
import org.jetbrains.annotations.NotNull;

public class RenderRegionManager {
    private final Long2ReferenceOpenHashMap<RenderRegion> regions = new Long2ReferenceOpenHashMap();
    private final BitSet regionIds = new BitSet();
    private int nextFreeId = 0;
    private final StagingBuffer stagingBuffer;
    private final RenderPassConfiguration<?> renderPassConfiguration;

    public RenderRegionManager(CommandList commandList, RenderPassConfiguration<?> renderPassConfiguration) {
        this.stagingBuffer = RenderRegionManager.createStagingBuffer(commandList);
        this.renderPassConfiguration = renderPassConfiguration;
    }

    public void update() {
        this.stagingBuffer.flip();
        try (CommandList commandList = RenderDevice.INSTANCE.createCommandList();){
            ObjectIterator it = this.regions.values().iterator();
            while (it.hasNext()) {
                RenderRegion region = (RenderRegion)it.next();
                region.update(commandList);
                if (!region.isEmpty()) continue;
                region.delete(commandList);
                it.remove();
                this.regionIds.clear(region.getId());
                this.nextFreeId = Math.min(this.nextFreeId, region.getId());
            }
        }
    }

    public void uploadMeshes(CommandList commandList, Collection<ChunkJobResult.Success<? extends ChunkTaskOutput>> results, Runnable graphUpdateTrigger) {
        for (Reference2ReferenceMap.Entry entry : this.createMeshUploadQueues(results)) {
            new MeshUploader(commandList, (RenderRegion)entry.getKey(), graphUpdateTrigger).processResults((Collection)entry.getValue());
        }
    }

    private static <K, V> ObjectIterable<Reference2ReferenceMap.Entry<K, V>> fastIterable(Reference2ReferenceMap<K, V> map) {
        ObjectSet entries = map.reference2ReferenceEntrySet();
        return entries instanceof Reference2ReferenceMap.FastEntrySet ? () -> ((Reference2ReferenceMap.FastEntrySet)entries).fastIterator() : entries;
    }

    private Reference2ReferenceMap.FastEntrySet<RenderRegion, List<ChunkTaskOutput>> createMeshUploadQueues(Collection<ChunkJobResult.Success<? extends ChunkTaskOutput>> results) {
        Reference2ReferenceOpenHashMap map = new Reference2ReferenceOpenHashMap();
        for (ChunkJobResult.Success<? extends ChunkTaskOutput> holder : results) {
            ChunkTaskOutput result = holder.output();
            List queue = (List)map.computeIfAbsent((Object)result.render.getRegion(), k -> new ArrayList());
            queue.add(result);
        }
        return map.reference2ReferenceEntrySet();
    }

    public void delete(CommandList commandList) {
        for (RenderRegion region : this.regions.values()) {
            region.delete(commandList);
        }
        this.regions.clear();
        this.stagingBuffer.delete(commandList);
    }

    public Collection<RenderRegion> getLoadedRegions() {
        return this.regions.values();
    }

    public StagingBuffer getStagingBuffer() {
        return this.stagingBuffer;
    }

    public RenderRegion createForChunk(int chunkX, int chunkY, int chunkZ) {
        return this.create(chunkX >> RenderRegion.REGION_WIDTH_SH, chunkY >> RenderRegion.REGION_HEIGHT_SH, chunkZ >> RenderRegion.REGION_LENGTH_SH);
    }

    private int getNextId() {
        int id = this.nextFreeId;
        this.nextFreeId = this.regionIds.nextClearBit(id + 1);
        this.regionIds.set(id);
        return id;
    }

    @NotNull
    private RenderRegion create(int x, int y, int z) {
        long key = RenderRegion.key(x, y, z);
        RenderRegion instance = (RenderRegion)this.regions.get(key);
        if (instance == null) {
            instance = new RenderRegion(x, y, z, this.getNextId(), this.stagingBuffer);
            this.regions.put(key, (Object)instance);
        }
        return instance;
    }

    public int getRegionIdsLength() {
        return this.regionIds.length();
    }

    private static StagingBuffer createStagingBuffer(CommandList commandList) {
        if (MappedStagingBuffer.isSupported(RenderDevice.INSTANCE)) {
            return new MappedStagingBuffer(commandList);
        }
        return new FallbackStagingBuffer(commandList);
    }

    private class MeshUploader {
        private final Map<GlVertexFormat, ArrayList<PendingSectionUpload>> uploadsByFormat = new Object2ObjectOpenHashMap(2);
        private final CommandList commandList;
        private final RenderRegion region;
        private final Runnable graphUpdateTrigger;
        private boolean needIndexBuffer;

        private MeshUploader(CommandList commandList, RenderRegion region, Runnable graphUpdateTrigger) {
            this.commandList = commandList;
            this.region = region;
            this.graphUpdateTrigger = graphUpdateTrigger;
        }

        private ArrayList<PendingSectionUpload> getUploadQueue(TerrainRenderPass pass) {
            return this.uploadsByFormat.computeIfAbsent(pass.vertexType().getVertexFormat(), $ -> new ArrayList());
        }

        private void processBuildResult(ChunkBuildOutput result) {
            this.region.removeMeshes(result.render.getSectionIndex());
            for (Reference2ReferenceMap.Entry entry : RenderRegionManager.fastIterable(result.meshes)) {
                BuiltSectionMeshParts mesh = Objects.requireNonNull((BuiltSectionMeshParts)entry.getValue());
                this.needIndexBuffer |= mesh.indexBuffer() != null;
                this.getUploadQueue((TerrainRenderPass)entry.getKey()).add(new PendingMeshRebuildUpload(result.render, mesh, (TerrainRenderPass)entry.getKey(), PendingUpload.of(mesh.vertexBuffer()), PendingUpload.of(mesh.indexBuffer())));
            }
        }

        private void processSortResult(ChunkSortOutput result) {
            this.needIndexBuffer = true;
            for (Reference2ReferenceMap.Entry entry : RenderRegionManager.fastIterable(result.meshes)) {
                TerrainRenderPass pass = (TerrainRenderPass)entry.getKey();
                ChunkSortOutput.SortedMesh mesh = (ChunkSortOutput.SortedMesh)entry.getValue();
                SectionRenderDataStorage storage = this.region.getStorage(pass);
                if (storage != null) {
                    storage.removeIndexBuffer(result.render.getSectionIndex());
                }
                this.getUploadQueue((TerrainRenderPass)entry.getKey()).add(new PendingMeshSortUpload(result.render, pass, PendingUpload.of(mesh.indexData())));
            }
        }

        public void processResults(Collection<? extends ChunkTaskOutput> results) {
            for (ChunkTaskOutput chunkTaskOutput : results) {
                if (chunkTaskOutput instanceof ChunkBuildOutput) {
                    ChunkBuildOutput result = (ChunkBuildOutput)chunkTaskOutput;
                    this.processBuildResult(result);
                    continue;
                }
                if (chunkTaskOutput instanceof ChunkSortOutput) {
                    ChunkSortOutput chunkSortOutput = (ChunkSortOutput)chunkTaskOutput;
                    this.processSortResult(chunkSortOutput);
                    continue;
                }
                throw new IllegalStateException("Unexpected result type: " + chunkTaskOutput.getClass().getName());
            }
            if (this.uploadsByFormat.isEmpty()) {
                return;
            }
            boolean bufferChanged = false;
            for (Map.Entry<GlVertexFormat, ArrayList<PendingSectionUpload>> entry : this.uploadsByFormat.entrySet()) {
                RenderRegion.DeviceResources resources = this.region.createResources(entry.getKey(), this.commandList);
                ArrayList<PendingSectionUpload> uploads = entry.getValue();
                GlBufferArena geometryArena = resources.getGeometryArena();
                bufferChanged |= geometryArena.upload(this.commandList, uploads.stream().map(PendingSectionUpload::vertexUpload).filter(Objects::nonNull));
                if (!this.needIndexBuffer) continue;
                bufferChanged |= resources.getOrCreateIndexArena(this.commandList).upload(this.commandList, uploads.stream().map(PendingSectionUpload::indexUpload).filter(Objects::nonNull));
            }
            if (bufferChanged) {
                this.region.refresh(this.commandList);
            }
            int n = this.region.getPassSetUpdateCount();
            for (ArrayList<PendingSectionUpload> uploads : this.uploadsByFormat.values()) {
                for (PendingSectionUpload upload : uploads) {
                    SectionRenderDataStorage storage = this.region.createStorage(upload.pass(), RenderRegionManager.this.renderPassConfiguration);
                    if (upload instanceof PendingMeshRebuildUpload) {
                        PendingMeshRebuildUpload meshUpload = (PendingMeshRebuildUpload)upload;
                        GlBufferSegment indexResult = upload.indexUpload() != null ? upload.indexUpload().getResult() : null;
                        storage.setMeshes(upload.section().getSectionIndex(), upload.vertexUpload().getResult(), indexResult, meshUpload.meshData().ranges());
                        continue;
                    }
                    if (upload instanceof PendingMeshSortUpload) {
                        storage.replaceIndexBuffer(upload.section().getSectionIndex(), upload.indexUpload().getResult());
                        continue;
                    }
                    throw new IllegalStateException();
                }
            }
            this.region.removeEmptyStorages();
            if (this.region.getPassSetUpdateCount() != n) {
                this.graphUpdateTrigger.run();
            }
        }
    }

    private record PendingMeshSortUpload(RenderSection section, TerrainRenderPass pass, PendingUpload indexUpload) implements PendingSectionUpload
    {
        @Override
        public PendingUpload vertexUpload() {
            return null;
        }
    }

    private record PendingMeshRebuildUpload(RenderSection section, BuiltSectionMeshParts meshData, TerrainRenderPass pass, PendingUpload vertexUpload, PendingUpload indexUpload) implements PendingSectionUpload
    {
    }

    private static interface PendingSectionUpload {
        public RenderSection section();

        public TerrainRenderPass pass();

        public PendingUpload vertexUpload();

        public PendingUpload indexUpload();
    }
}

