/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.multidraw;

import org.embeddedt.embeddium.impl.gl.buffer.GlBufferTarget;
import org.embeddedt.embeddium.impl.gl.buffer.GlBufferUsage;
import org.embeddedt.embeddium.impl.gl.buffer.GlMutableBuffer;
import org.embeddedt.embeddium.impl.gl.device.CommandList;
import org.embeddedt.embeddium.impl.gl.device.DrawCommandList;
import org.embeddedt.embeddium.impl.gl.tessellation.GlIndexType;
import org.embeddedt.embeddium.impl.gl.tessellation.GlPrimitiveType;
import org.embeddedt.embeddium.impl.gl.tessellation.GlTessellation;
import org.embeddedt.embeddium.impl.model.quad.properties.ModelQuadFacing;
import org.embeddedt.embeddium.impl.render.chunk.data.SectionRenderDataUnsafe;
import org.embeddedt.embeddium.impl.render.chunk.multidraw.MultiDrawEmitter;
import org.lwjgl.system.MemoryUtil;

public class IndirectMultiDrawEmitter
implements MultiDrawEmitter {
    private static final int COMMAND_SIZE = 20;
    private static final int BUFFER_SIZE = MultiDrawEmitter.MAX_COMMAND_COUNT * 20;
    private final long indirectBuffer = MemoryUtil.nmemAlignedAlloc((long)32L, (long)BUFFER_SIZE);
    private int numCommands;
    private final GlMutableBuffer indirectBufferGpu;

    public IndirectMultiDrawEmitter() {
        if (this.indirectBuffer == 0L) {
            throw new OutOfMemoryError("Failed to allocate indirect buffer");
        }
        this.prefillConstants();
        this.indirectBufferGpu = new GlMutableBuffer();
    }

    private void prefillConstants() {
        long ptr = this.indirectBuffer;
        for (int i = 0; i < MultiDrawEmitter.MAX_COMMAND_COUNT; ++i) {
            MemoryUtil.memPutInt((long)(ptr + 4L), (int)1);
            MemoryUtil.memPutInt((long)(ptr + 16L), (int)0);
            ptr += 20L;
        }
    }

    @Override
    public void addDrawCommands(long pMeshData, int facingMask, int indexPointerMask) {
        int size = this.numCommands;
        long basePtr = this.indirectBuffer;
        for (int facing = 0; facing < ModelQuadFacing.COUNT; ++facing) {
            long ptr = basePtr + (long)size * 20L;
            MemoryUtil.memPutInt((long)(ptr + 0L), (int)SectionRenderDataUnsafe.getElementCount(pMeshData, facing));
            int indexOffset = SectionRenderDataUnsafe.getIndexOffset(pMeshData, facing) & indexPointerMask;
            MemoryUtil.memPutInt((long)(ptr + 8L), (int)(indexOffset / 4));
            MemoryUtil.memPutInt((long)(ptr + 12L), (int)SectionRenderDataUnsafe.getVertexOffset(pMeshData, facing));
            size += facingMask >> facing & 1;
        }
        this.numCommands = size;
    }

    @Override
    public void executeBatch(CommandList commandList, GlTessellation tessellation, GlPrimitiveType primitiveType) {
        commandList.uploadData(this.indirectBufferGpu, this.indirectBuffer, (long)this.numCommands * 20L, GlBufferUsage.STREAM_DRAW);
        commandList.bindBuffer(GlBufferTarget.DRAW_INDIRECT_BUFFER, this.indirectBufferGpu);
        try (DrawCommandList drawCommandList = commandList.beginTessellating(tessellation);){
            drawCommandList.multiDrawElementsIndirect(this.indirectBufferGpu, this.numCommands, primitiveType, GlIndexType.UNSIGNED_INT);
        }
        commandList.bindBuffer(GlBufferTarget.DRAW_INDIRECT_BUFFER, null);
    }

    @Override
    public boolean isEmpty() {
        return this.numCommands == 0;
    }

    @Override
    public int getIndexBufferSize() {
        int elements = 0;
        long pElementCount = this.indirectBuffer;
        for (int index = 0; index < this.numCommands; ++index) {
            elements = Math.max(elements, MemoryUtil.memGetInt((long)pElementCount));
            pElementCount += 20L;
        }
        return elements;
    }

    @Override
    public void clear() {
        this.numCommands = 0;
    }

    @Override
    public void delete() {
        MemoryUtil.nmemFree((long)this.indirectBuffer);
        this.indirectBufferGpu.delete();
    }
}

