/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.metrics;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.PriorityQueue;
import org.embeddedt.embeddium.impl.render.chunk.RenderSection;

public class RenderSectionMetricsTracker {
    public static final Comparator<RenderSection> BY_BUILD_TIME = Comparator.comparingLong(RenderSection::getLastBuildDurationNanos);
    private static final int MAX_TRACKED_SECTIONS = 5;
    private final PriorityQueue<RenderSection> slowestSections = new PriorityQueue<RenderSection>(BY_BUILD_TIME);
    private final ReferenceOpenHashSet<RenderSection> sectionsInHeap = new ReferenceOpenHashSet();

    private void addSection(RenderSection section) {
        this.slowestSections.add(section);
        this.sectionsInHeap.add((Object)section);
    }

    public void removeSection(RenderSection section) {
        if (this.sectionsInHeap.remove((Object)section)) {
            this.slowestSections.remove(section);
        }
    }

    public void updateSectionBuildDuration(RenderSection section, long duration) {
        this.removeSection(section);
        section.setLastBuildDurationNanos(duration);
        if (this.slowestSections.size() < 5) {
            this.addSection(section);
        } else if (duration > this.slowestSections.peek().getLastBuildDurationNanos()) {
            this.sectionsInHeap.remove((Object)this.slowestSections.poll());
            this.addSection(section);
        }
    }

    public Collection<RenderSection> getSlowestSections() {
        return Collections.unmodifiableCollection(this.slowestSections);
    }
}

