/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.lists;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayDeque;
import java.util.EnumMap;
import java.util.Queue;
import org.embeddedt.embeddium.impl.render.chunk.ChunkUpdateType;
import org.embeddedt.embeddium.impl.render.chunk.RenderSection;
import org.embeddedt.embeddium.impl.render.chunk.lists.ChunkRebuildLists;
import org.embeddedt.embeddium.impl.render.chunk.lists.ChunkRenderList;
import org.embeddedt.embeddium.impl.render.chunk.lists.SortedRenderLists;
import org.embeddedt.embeddium.impl.render.chunk.occlusion.OcclusionCuller;
import org.embeddedt.embeddium.impl.render.chunk.occlusion.OcclusionNode;
import org.embeddedt.embeddium.impl.render.chunk.region.RenderRegion;

public class VisibleChunkCollector
implements OcclusionCuller.Visitor {
    private final ObjectArrayList<ChunkRenderList> sortedRenderLists;
    private final EnumMap<ChunkUpdateType, ArrayDeque<RenderSection>> sortedRebuildLists;
    private final int[] rebuildQueueOverflowCounts;
    private final ChunkRenderList[] renderListsByRegion;
    private final int frame;
    private final boolean ignoreQueueSizeLimit;
    private boolean hasAdditionalUpdates;

    public VisibleChunkCollector(int frame, int regionIdsLength, boolean ignoreQueueSizeLimit) {
        this.frame = frame;
        this.sortedRenderLists = new ObjectArrayList();
        this.sortedRebuildLists = new EnumMap(ChunkUpdateType.class);
        this.rebuildQueueOverflowCounts = new int[ChunkUpdateType.values().length];
        this.ignoreQueueSizeLimit = ignoreQueueSizeLimit;
        this.renderListsByRegion = new ChunkRenderList[regionIdsLength];
        for (ChunkUpdateType type : ChunkUpdateType.values()) {
            this.sortedRebuildLists.put(type, new ArrayDeque());
        }
    }

    private ChunkRenderList createRenderList(RenderRegion region) {
        ChunkRenderList renderList = new ChunkRenderList(region);
        this.sortedRenderLists.add((Object)renderList);
        this.renderListsByRegion[region.getId()] = renderList;
        return renderList;
    }

    @Override
    public void visit(OcclusionNode node, boolean visible) {
        RenderSection section = node.getRenderSection();
        int regionId = node.getRenderRegionId();
        ChunkRenderList renderList = this.renderListsByRegion[regionId];
        if (renderList == null) {
            renderList = this.createRenderList(section.getRegion());
        }
        if (visible) {
            if (section.hasAnythingToRender()) {
                renderList.add(section);
            }
            this.addToRebuildLists(section);
        }
    }

    private void addToRebuildLists(RenderSection section) {
        ChunkUpdateType type = section.getPendingUpdate();
        if (type != null && section.getBuildCancellationToken() == null) {
            Queue queue = this.sortedRebuildLists.get((Object)type);
            if (this.ignoreQueueSizeLimit || queue.size() < type.getMaximumQueueSize()) {
                queue.add(section);
            } else {
                int n = type.ordinal();
                this.rebuildQueueOverflowCounts[n] = this.rebuildQueueOverflowCounts[n] + 1;
                this.hasAdditionalUpdates = true;
            }
        }
    }

    public SortedRenderLists createRenderLists() {
        return new SortedRenderLists(this.sortedRenderLists);
    }

    public ChunkRebuildLists getRebuildLists() {
        EnumMap<ChunkUpdateType, Integer> overflowCounts = new EnumMap<ChunkUpdateType, Integer>(ChunkUpdateType.class);
        if (this.hasAdditionalUpdates) {
            ChunkUpdateType[] values = ChunkUpdateType.values();
            for (int i = 0; i < values.length; ++i) {
                if (this.rebuildQueueOverflowCounts[i] == 0) continue;
                overflowCounts.put(values[i], this.rebuildQueueOverflowCounts[i]);
            }
        }
        return new ChunkRebuildLists(this.sortedRebuildLists, this.hasAdditionalUpdates, overflowCounts);
    }

    ObjectArrayList<ChunkRenderList> getSortedRenderLists() {
        return this.sortedRenderLists;
    }
}

