/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.compile.executor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkBuildContext;
import org.embeddedt.embeddium.impl.render.chunk.compile.GlobalChunkBuildContext;
import org.embeddedt.embeddium.impl.render.chunk.compile.executor.ChunkJob;
import org.embeddedt.embeddium.impl.render.chunk.compile.executor.ChunkJobQueue;
import org.embeddedt.embeddium.impl.render.chunk.compile.executor.ChunkJobResult;
import org.embeddedt.embeddium.impl.render.chunk.compile.executor.ChunkJobTyped;
import org.embeddedt.embeddium.impl.render.chunk.compile.tasks.ChunkBuilderTask;

public class ChunkBuilder {
    static final Logger LOGGER = LogManager.getLogger((String)"ChunkBuilder");
    private static final int MBS_PER_CHUNK_BUILDER = 64;
    private static final int TASK_QUEUE_LIMIT_PER_WORKER = 2;
    private final ChunkJobQueue queue = new ChunkJobQueue();
    private final List<WorkerThread> threads = new ArrayList<WorkerThread>();
    private final AtomicInteger busyThreadCount = new AtomicInteger();
    private final ChunkBuildContext localContext;
    private final ManagedBlocker managedBlocker;

    public ChunkBuilder(ManagedBlocker managedBlocker, Supplier<ChunkBuildContext> contextSupplier, int requestedThreads) {
        GlobalChunkBuildContext.setMainThread();
        if (requestedThreads >= 0) {
            int count = ChunkBuilder.getThreadCount(requestedThreads);
            for (int i = 0; i < count; ++i) {
                ChunkBuildContext context = contextSupplier.get();
                WorkerRunnable worker = new WorkerRunnable(context);
                WorkerThread thread = new WorkerThread(worker, "Chunk Render Task Executor #" + i, context);
                thread.setPriority(Math.max(0, 3));
                thread.start();
                this.threads.add(thread);
            }
        }
        LOGGER.info("Started {} worker threads", new Object[]{this.threads.size()});
        this.localContext = contextSupplier.get();
        this.managedBlocker = managedBlocker;
    }

    public int getSchedulingBudget() {
        return Math.max(0, Math.max(1, this.threads.size()) * 2 - this.queue.size());
    }

    public void shutdown() {
        if (!this.queue.isRunning()) {
            throw new IllegalStateException("Worker threads are not running");
        }
        Collection<ChunkJob> jobs = this.queue.shutdown();
        for (ChunkJob job : jobs) {
            job.setCancelled();
        }
        this.shutdownThreads();
    }

    private void shutdownThreads() {
        LOGGER.info("Stopping worker threads");
        for (WorkerThread thread : this.threads) {
            this.managedBlocker.managedBlock(() -> !thread.isAlive());
        }
        this.threads.clear();
    }

    public <TASK extends ChunkBuilderTask<OUTPUT>, OUTPUT> ChunkJobTyped<TASK, OUTPUT> scheduleTask(TASK task, boolean important, Consumer<ChunkJobResult<OUTPUT>> consumer) {
        Objects.requireNonNull(task, "Task must be non-null");
        if (!this.queue.isRunning()) {
            throw new IllegalStateException("Executor is stopped");
        }
        ChunkJobTyped<TASK, OUTPUT> job = new ChunkJobTyped<TASK, OUTPUT>(task, consumer);
        this.queue.add(job, important);
        return job;
    }

    private static int getOptimalThreadCount() {
        int desiredThreads = Math.max(ChunkBuilder.getMaxThreadCount() / 3, ChunkBuilder.getMaxThreadCount() - 6);
        if (desiredThreads < 1) {
            return 1;
        }
        if (desiredThreads > 10) {
            return 10;
        }
        return desiredThreads;
    }

    private static int getThreadCount(int requested) {
        return requested == 0 ? ChunkBuilder.getOptimalThreadCount() : Math.min(requested, ChunkBuilder.getMaxThreadCount());
    }

    public static int getMaxThreadCount() {
        int totalCores = Runtime.getRuntime().availableProcessors();
        long memoryMb = Runtime.getRuntime().maxMemory() / 0x100000L;
        int maxBuilders = Math.max(1, (int)(memoryMb / 64L));
        return Math.min(totalCores, maxBuilders);
    }

    public void tryStealTask(ChunkJob job) {
        if (!this.queue.stealJob(job)) {
            return;
        }
        this.executeJobWithLocalContext(job);
    }

    private void executeJobWithLocalContext(ChunkJob job) {
        ChunkBuildContext localContext = this.localContext;
        GlobalChunkBuildContext.bindMainThread(localContext);
        try {
            job.execute(localContext);
        }
        finally {
            GlobalChunkBuildContext.bindMainThread(null);
            localContext.cleanup();
        }
    }

    public void tick() {
        if (!this.threads.isEmpty()) {
            return;
        }
        while (!this.queue.isEmpty()) {
            ChunkJob job = Objects.requireNonNull(this.queue.pollJob());
            this.executeJobWithLocalContext(job);
        }
    }

    public boolean isBuildQueueEmpty() {
        return this.queue.isEmpty();
    }

    public int getScheduledJobCount() {
        return this.queue.size();
    }

    public int getBusyThreadCount() {
        return this.busyThreadCount.get();
    }

    public int getTotalThreadCount() {
        return this.threads.size();
    }

    public void managedBlock(BooleanSupplier isDone) {
        this.managedBlocker.managedBlock(isDone);
    }

    private class WorkerRunnable
    implements Runnable {
        private final ChunkBuildContext context;

        public WorkerRunnable(ChunkBuildContext context) {
            this.context = context;
        }

        @Override
        public void run() {
            while (ChunkBuilder.this.queue.isRunning()) {
                ChunkJob job;
                try {
                    job = ChunkBuilder.this.queue.waitForNextJob();
                }
                catch (InterruptedException ignored) {
                    continue;
                }
                if (job == null) continue;
                ChunkBuilder.this.busyThreadCount.getAndIncrement();
                try {
                    job.execute(this.context);
                }
                finally {
                    this.context.cleanup();
                    ChunkBuilder.this.busyThreadCount.decrementAndGet();
                }
            }
        }
    }

    public static final class WorkerThread
    extends Thread
    implements GlobalChunkBuildContext.Holder {
        private final ChunkBuildContext context;

        public WorkerThread(Runnable runnable, String name, ChunkBuildContext context) {
            super(runnable, name);
            this.context = context;
        }

        @Override
        public ChunkBuildContext embeddium$getGlobalContext() {
            return this.context;
        }
    }

    public static interface ManagedBlocker {
        public static final ManagedBlocker NONE = isDone -> {
            while (!isDone.getAsBoolean()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        };

        public void managedBlock(BooleanSupplier var1);
    }
}

