/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.model.light.data;

import java.util.Arrays;
import org.embeddedt.embeddium.impl.model.quad.properties.ModelQuadFacing;

public abstract class LightDataAccess {
    private static final int NEIGHBOR_BLOCK_RADIUS = 2;
    private static final int BLOCK_LENGTH = 20;
    private final int[] light = new int[8000];
    private int xOffset;
    private int yOffset;
    private int zOffset;
    public static final int FULL_BRIGHT = LightDataAccess.pack(15, 15);

    public void reset(int minBlockX, int minBlockY, int minBlockZ) {
        this.xOffset = minBlockX - 2;
        this.yOffset = minBlockY - 2;
        this.zOffset = minBlockZ - 2;
        Arrays.fill(this.light, 0);
    }

    private int index(int x, int y, int z) {
        int x2 = x - this.xOffset;
        int y2 = y - this.yOffset;
        int z2 = z - this.zOffset;
        return z2 * 20 * 20 + y2 * 20 + x2;
    }

    protected abstract int compute(int var1, int var2, int var3);

    public int get(int x, int y, int z) {
        int l = this.index(x, y, z);
        int word = this.light[l];
        if (word != 0) {
            return word;
        }
        this.light[l] = this.compute(x, y, z);
        return this.light[l];
    }

    public int get(int x, int y, int z, ModelQuadFacing d1, ModelQuadFacing d2) {
        return this.get(x + d1.getStepX() + d2.getStepX(), y + d1.getStepY() + d2.getStepY(), z + d1.getStepZ() + d2.getStepZ());
    }

    public int get(int x, int y, int z, ModelQuadFacing dir) {
        return this.get(x + dir.getStepX(), y + dir.getStepY(), z + dir.getStepZ());
    }

    public static int packBL(int blockLight) {
        return blockLight & 0xF;
    }

    public static int unpackBL(int word) {
        return word & 0xF;
    }

    public static int packSL(int skyLight) {
        return (skyLight & 0xF) << 4;
    }

    public static int unpackSL(int word) {
        return word >>> 4 & 0xF;
    }

    public static int packLU(int luminance) {
        return (luminance & 0xF) << 8;
    }

    public static int unpackLU(int word) {
        return word >>> 8 & 0xF;
    }

    public static int packAO(float ao) {
        int aoi = (int)(ao * 4096.0f);
        return (aoi & 0xFFFF) << 12;
    }

    public static float unpackAO(int word) {
        int aoi = word >>> 12 & 0xFFFF;
        return (float)aoi * 2.4414062E-4f;
    }

    public static int packEM(boolean emissive) {
        return (emissive ? 1 : 0) << 28;
    }

    public static boolean unpackEM(int word) {
        return (word >>> 28 & 1) != 0;
    }

    public static int packOP(boolean opaque) {
        return (opaque ? 1 : 0) << 29;
    }

    public static boolean unpackOP(int word) {
        return (word >>> 29 & 1) != 0;
    }

    public static int packFO(boolean opaque) {
        return (opaque ? 1 : 0) << 30;
    }

    public static boolean unpackFO(int word) {
        return (word >>> 30 & 1) != 0;
    }

    public static int packFC(boolean fullCube) {
        return (fullCube ? 1 : 0) << 31;
    }

    public static boolean unpackFC(int word) {
        return (word >>> 31 & 1) != 0;
    }

    public static int pack(int block, int sky) {
        return block << 4 | sky << 20;
    }

    public static int unpackBlock(int packed) {
        return (packed & 0xFFFF) >> 4;
    }

    public static int unpackSky(int packed) {
        return packed >> 20 & 0xFFFF;
    }

    public static int getLightmap(int word) {
        return LightDataAccess.pack(Math.max(LightDataAccess.unpackBL(word), LightDataAccess.unpackLU(word)), LightDataAccess.unpackSL(word));
    }

    public static int getEmissiveLightmap(int word) {
        if (LightDataAccess.unpackEM(word)) {
            return FULL_BRIGHT;
        }
        return LightDataAccess.getLightmap(word);
    }
}

