/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gl.tessellation;

import org.embeddedt.embeddium.impl.gl.attribute.GlVertexAttributeBinding;
import org.embeddedt.embeddium.impl.gl.device.CommandList;
import org.embeddedt.embeddium.impl.gl.tessellation.GlTessellation;
import org.embeddedt.embeddium.impl.gl.tessellation.TessellationBinding;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GL30C;

public abstract class GlAbstractTessellation
implements GlTessellation {
    protected final TessellationBinding[] bindings;

    protected GlAbstractTessellation(TessellationBinding[] bindings) {
        this.bindings = bindings;
    }

    protected void bindAttributes(CommandList commandList) {
        for (TessellationBinding binding : this.bindings) {
            commandList.bindBuffer(binding.target(), binding.buffer());
            for (GlVertexAttributeBinding attrib : binding.attributeBindings()) {
                if (attrib.isIntType()) {
                    GL30C.glVertexAttribIPointer((int)attrib.getIndex(), (int)attrib.getCount(), (int)attrib.getFormat().typeId(), (int)attrib.getStride(), (long)attrib.getPointer());
                } else {
                    GL20C.glVertexAttribPointer((int)attrib.getIndex(), (int)attrib.getCount(), (int)attrib.getFormat().typeId(), (boolean)attrib.isNormalized(), (int)attrib.getStride(), (long)attrib.getPointer());
                }
                GL20C.glEnableVertexAttribArray((int)attrib.getIndex());
            }
        }
    }
}

