/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gl.functions;

import org.embeddedt.embeddium.impl.gl.device.RenderDevice;
import org.lwjgl.opengl.ARBDrawElementsBaseVertex;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum MultidrawFunctions {
    NONE{

        @Override
        public void multiDrawElementsBaseVertex(int mode, long pCount, int type, long pIndices, int size, long pBaseVertex) {
            throw new UnsupportedOperationException("Platform does not support DrawElementsBaseVertex");
        }
    }
    ,
    FALLBACK{

        @Override
        public void multiDrawElementsBaseVertex(int mode, long pCount, int type, long pIndices, int size, long pBaseVertex) {
            for (int i = 0; i < size; ++i) {
                long off = (long)i * 4L;
                int count = MemoryUtil.memGetInt((long)(pCount + off));
                if (count <= 0) continue;
                ARBDrawElementsBaseVertex.nglDrawElementsBaseVertex((int)mode, (int)count, (int)type, (long)MemoryUtil.memGetAddress((long)(pIndices + (long)i * (long)Pointer.POINTER_SIZE)), (int)MemoryUtil.memGetInt((long)(pBaseVertex + off)));
            }
        }
    }
    ,
    CORE{

        @Override
        public void multiDrawElementsBaseVertex(int mode, long pCount, int type, long pIndices, int size, long pBaseVertex) {
            GL32C.nglMultiDrawElementsBaseVertex((int)mode, (long)pCount, (int)type, (long)pIndices, (int)size, (long)pBaseVertex);
        }
    };


    public static MultidrawFunctions pickBest(RenderDevice device) {
        GLCapabilities capabilities = device.getCapabilities();
        if (capabilities.OpenGL32) {
            return CORE;
        }
        if (capabilities.GL_ARB_draw_elements_base_vertex) {
            return FALLBACK;
        }
        return NONE;
    }

    public abstract void multiDrawElementsBaseVertex(int var1, long var2, int var4, long var5, int var7, long var8);
}

