/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gl.device;

import java.nio.ByteBuffer;
import org.embeddedt.embeddium.impl.gl.array.GlVertexArray;
import org.embeddedt.embeddium.impl.gl.buffer.GlBuffer;
import org.embeddedt.embeddium.impl.gl.buffer.GlBufferMapFlags;
import org.embeddedt.embeddium.impl.gl.buffer.GlBufferMapping;
import org.embeddedt.embeddium.impl.gl.buffer.GlBufferStorageFlags;
import org.embeddedt.embeddium.impl.gl.buffer.GlBufferTarget;
import org.embeddedt.embeddium.impl.gl.buffer.GlBufferUsage;
import org.embeddedt.embeddium.impl.gl.buffer.GlImmutableBuffer;
import org.embeddedt.embeddium.impl.gl.buffer.GlMutableBuffer;
import org.embeddedt.embeddium.impl.gl.device.CommandList;
import org.embeddedt.embeddium.impl.gl.device.DrawCommandList;
import org.embeddedt.embeddium.impl.gl.device.MultiDrawBatch;
import org.embeddedt.embeddium.impl.gl.device.RenderDevice;
import org.embeddedt.embeddium.impl.gl.functions.DeviceFunctions;
import org.embeddedt.embeddium.impl.gl.state.GlStateTracker;
import org.embeddedt.embeddium.impl.gl.sync.GlFence;
import org.embeddedt.embeddium.impl.gl.tessellation.GlIndexType;
import org.embeddedt.embeddium.impl.gl.tessellation.GlPrimitiveType;
import org.embeddedt.embeddium.impl.gl.tessellation.GlTessellation;
import org.embeddedt.embeddium.impl.gl.util.EnumBitField;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.opengl.GL31C;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.opengl.GL43C;
import org.lwjgl.opengl.GLCapabilities;

public class GLRenderDevice
implements RenderDevice {
    private final GlStateTracker stateTracker = new GlStateTracker();
    private final CommandList commandList = new ImmediateCommandList(this.stateTracker);
    private final DrawCommandList drawCommandList = new ImmediateDrawCommandList();
    private final DeviceFunctions functions = new DeviceFunctions(this);
    private boolean isActive;
    private GlTessellation activeTessellation;
    public static Runnable VANILLA_STATE_RESETTER = () -> {
        throw new IllegalStateException("The host mod should replace the VANILLA_STATE_RESETTER with an implementation specific to the platform.");
    };

    @Override
    public CommandList createCommandList() {
        this.checkDeviceActive();
        return this.commandList;
    }

    @Override
    public void makeActive() {
        if (this.isActive) {
            return;
        }
        VANILLA_STATE_RESETTER.run();
        this.stateTracker.clear();
        this.isActive = true;
    }

    @Override
    public void makeInactive() {
        if (!this.isActive) {
            return;
        }
        VANILLA_STATE_RESETTER.run();
        this.stateTracker.clear();
        this.isActive = false;
    }

    @Override
    public GLCapabilities getCapabilities() {
        return GL.getCapabilities();
    }

    @Override
    public DeviceFunctions getDeviceFunctions() {
        return this.functions;
    }

    private void checkDeviceActive() {
        if (!this.isActive) {
            throw new IllegalStateException("Tried to access device from unmanaged context");
        }
    }

    private class ImmediateCommandList
    implements CommandList {
        private final GlStateTracker stateTracker;

        private ImmediateCommandList(GlStateTracker stateTracker) {
            this.stateTracker = stateTracker;
        }

        @Override
        public void bindVertexArray(GlVertexArray array) {
            if (this.stateTracker.makeVertexArrayActive(array)) {
                GL30C.glBindVertexArray((int)array.handle());
            }
        }

        @Override
        public void uploadData(GlMutableBuffer glBuffer, ByteBuffer byteBuffer, GlBufferUsage usage) {
            this.bindBuffer(GlBufferTarget.ARRAY_BUFFER, glBuffer);
            GL20C.glBufferData((int)GlBufferTarget.ARRAY_BUFFER.getTargetParameter(), (ByteBuffer)byteBuffer, (int)usage.getId());
            glBuffer.setSize(byteBuffer.remaining());
        }

        @Override
        public void uploadData(GlMutableBuffer glBuffer, long ptr, long bytes, GlBufferUsage usage) {
            this.bindBuffer(GlBufferTarget.ARRAY_BUFFER, glBuffer);
            GL20C.nglBufferData((int)GlBufferTarget.ARRAY_BUFFER.getTargetParameter(), (long)bytes, (long)ptr, (int)usage.getId());
            glBuffer.setSize(bytes);
        }

        @Override
        public void copyBufferSubData(GlBuffer src, GlBuffer dst, long readOffset, long writeOffset, long bytes) {
            this.bindBuffer(GlBufferTarget.COPY_READ_BUFFER, src);
            this.bindBuffer(GlBufferTarget.COPY_WRITE_BUFFER, dst);
            GL31C.glCopyBufferSubData((int)36662, (int)36663, (long)readOffset, (long)writeOffset, (long)bytes);
        }

        @Override
        public void bindBuffer(GlBufferTarget target, @Nullable GlBuffer buffer) {
            if (this.stateTracker.makeBufferActive(target, buffer)) {
                GL20C.glBindBuffer((int)target.getTargetParameter(), (int)(buffer != null ? buffer.handle() : 0));
            }
        }

        @Override
        public void unbindVertexArray() {
            if (this.stateTracker.makeVertexArrayActive(null)) {
                GL30C.glBindVertexArray((int)0);
            }
        }

        @Override
        public void allocateStorage(GlMutableBuffer buffer, long bufferSize, GlBufferUsage usage) {
            this.bindBuffer(GlBufferTarget.ARRAY_BUFFER, buffer);
            GL20C.glBufferData((int)GlBufferTarget.ARRAY_BUFFER.getTargetParameter(), (long)bufferSize, (int)usage.getId());
            buffer.setSize(bufferSize);
        }

        @Override
        public void deleteBuffer(GlBuffer buffer) {
            if (buffer.getActiveMapping() != null) {
                this.unmap(buffer.getActiveMapping());
            }
            this.stateTracker.notifyBufferDeleted(buffer);
            buffer.delete();
        }

        @Override
        public void deleteVertexArray(GlVertexArray vertexArray) {
            this.stateTracker.notifyVertexArrayDeleted(vertexArray);
            vertexArray.delete();
        }

        @Override
        public void flush() {
        }

        @Override
        public DrawCommandList beginTessellating(GlTessellation tessellation) {
            GLRenderDevice.this.activeTessellation = tessellation;
            GLRenderDevice.this.activeTessellation.bind(GLRenderDevice.this.commandList);
            return GLRenderDevice.this.drawCommandList;
        }

        @Override
        public void deleteTessellation(GlTessellation tessellation) {
            tessellation.delete(this);
        }

        @Override
        public GlBufferMapping mapBuffer(GlBuffer buffer, long offset, long length, EnumBitField<GlBufferMapFlags> flags) {
            if (buffer.getActiveMapping() != null) {
                throw new IllegalStateException("Buffer is already mapped");
            }
            if (flags.contains(GlBufferMapFlags.PERSISTENT) && !(buffer instanceof GlImmutableBuffer)) {
                throw new IllegalStateException("Tried to map mutable buffer as persistent");
            }
            if (buffer instanceof GlImmutableBuffer) {
                EnumBitField<GlBufferStorageFlags> bufferFlags = ((GlImmutableBuffer)buffer).getFlags();
                if (flags.contains(GlBufferMapFlags.PERSISTENT) && !bufferFlags.contains(GlBufferStorageFlags.PERSISTENT)) {
                    throw new IllegalArgumentException("Tried to map non-persistent buffer as persistent");
                }
                if (flags.contains(GlBufferMapFlags.WRITE) && !bufferFlags.contains(GlBufferStorageFlags.MAP_WRITE)) {
                    throw new IllegalStateException("Tried to map non-writable buffer as writable");
                }
                if (flags.contains(GlBufferMapFlags.READ) && !bufferFlags.contains(GlBufferStorageFlags.MAP_READ)) {
                    throw new IllegalStateException("Tried to map non-readable buffer as readable");
                }
            }
            this.bindBuffer(GlBufferTarget.ARRAY_BUFFER, buffer);
            ByteBuffer buf = GL32C.glMapBufferRange((int)GlBufferTarget.ARRAY_BUFFER.getTargetParameter(), (long)offset, (long)length, (int)flags.getBitField());
            if (buf == null) {
                throw new RuntimeException("Failed to map buffer");
            }
            GlBufferMapping mapping = new GlBufferMapping(buffer, buf);
            buffer.setActiveMapping(mapping);
            return mapping;
        }

        @Override
        public void unmap(GlBufferMapping map) {
            this.checkMapDisposed(map);
            GlBuffer buffer = map.getBufferObject();
            this.bindBuffer(GlBufferTarget.ARRAY_BUFFER, buffer);
            GL32C.glUnmapBuffer((int)GlBufferTarget.ARRAY_BUFFER.getTargetParameter());
            buffer.setActiveMapping(null);
            map.dispose();
        }

        @Override
        public void flushMappedRange(GlBufferMapping map, int offset, int length) {
            this.checkMapDisposed(map);
            GlBuffer buffer = map.getBufferObject();
            this.bindBuffer(GlBufferTarget.COPY_READ_BUFFER, buffer);
            GL32C.glFlushMappedBufferRange((int)GlBufferTarget.COPY_READ_BUFFER.getTargetParameter(), (long)offset, (long)length);
        }

        @Override
        public GlFence createFence() {
            return new GlFence(GL32C.glFenceSync((int)37143, (int)0));
        }

        private void checkMapDisposed(GlBufferMapping map) {
            if (map.isDisposed()) {
                throw new IllegalStateException("Buffer mapping is already disposed");
            }
        }

        @Override
        public GlMutableBuffer createMutableBuffer() {
            return new GlMutableBuffer();
        }

        @Override
        public GlImmutableBuffer createImmutableBuffer(long bufferSize, EnumBitField<GlBufferStorageFlags> flags) {
            GlImmutableBuffer buffer = new GlImmutableBuffer(flags);
            this.bindBuffer(GlBufferTarget.ARRAY_BUFFER, buffer);
            GLRenderDevice.this.functions.bufferStorageFunctions().createBufferStorage(GlBufferTarget.ARRAY_BUFFER, bufferSize, flags);
            return buffer;
        }
    }

    private class ImmediateDrawCommandList
    implements DrawCommandList {
        @Override
        public void multiDrawElementsBaseVertex(MultiDrawBatch batch, GlPrimitiveType primitiveType, GlIndexType indexType) {
            GLRenderDevice.this.functions.multidrawFunctions().multiDrawElementsBaseVertex(primitiveType.getId(), batch.pElementCount, indexType.getFormatId(), batch.pElementPointer, batch.size(), batch.pBaseVertex);
        }

        @Override
        public void multiDrawElementsIndirect(GlBuffer indirectBuffer, int count, GlPrimitiveType primitiveType, GlIndexType indexType) {
            GL43C.glMultiDrawElementsIndirect((int)primitiveType.getId(), (int)indexType.getFormatId(), (long)0L, (int)count, (int)0);
        }

        @Override
        public void endTessellating() {
            GLRenderDevice.this.activeTessellation.unbind(GLRenderDevice.this.commandList);
            GLRenderDevice.this.activeTessellation = null;
        }

        @Override
        public void flush() {
            if (GLRenderDevice.this.activeTessellation != null) {
                this.endTessellating();
            }
        }
    }
}

