/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.beddium.modules.TerrainRendering.fog;

import com.falsepattern.lib.util.MathUtil;
import com.ventooth.beddium.config.TerrainRenderingConfig;
import com.ventooth.beddium.modules.TerrainRendering.fog.FogAsmHooks;
import com.ventooth.beddium.modules.TerrainRendering.fog.FogGL;
import com.ventooth.beddium.modules.TerrainRendering.fog.FogState;
import org.lwjgl.opengl.GL11;

public final class FogHandler {
    public static boolean DEBUG;

    private FogHandler() {
        throw new UnsupportedOperationException();
    }

    public static void preSetupFog(float farPlaneDistance) {
        if (TerrainRenderingConfig.FastFog) {
            FogState.setDefault(farPlaneDistance);
            FogGL.write();
        }
        FogAsmHooks.enable();
    }

    public static void postSetupFog(float farPlaneDistance) {
        FogAsmHooks.disable();
        if (TerrainRenderingConfig.ChunkDrawMode == TerrainRenderingConfig.DrawModeEnum.Fast) {
            FogHandler.applyBias(farPlaneDistance);
        }
    }

    private static void applyBias(float farPlaneDistance) {
        float fogStart;
        float fogEnd;
        float fogBias = (float)TerrainRenderingConfig.FastChunkDrawModeFogBias;
        if (MathUtil.epsilonEquals((float)fogBias, (float)0.0f)) {
            return;
        }
        if (TerrainRenderingConfig.FastFog) {
            fogEnd = FogState.end;
            fogStart = FogState.start;
        } else {
            fogEnd = GL11.glGetInteger((int)2916);
            fogStart = GL11.glGetInteger((int)2915);
        }
        float maxFogEnd = farPlaneDistance + fogBias;
        if (maxFogEnd >= fogEnd || fogStart > fogEnd) {
            return;
        }
        float biasRatio = maxFogEnd / fogEnd;
        fogEnd = maxFogEnd;
        GL11.glFogf((int)2916, (float)fogEnd);
        GL11.glFogf((int)2915, (float)(fogStart *= biasRatio));
        if (TerrainRenderingConfig.FastFog) {
            FogState.end = fogEnd;
            FogState.start = fogStart;
        }
    }
}

