/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.beddium.modules.TerrainRendering.fog;

import com.falsepattern.lib.util.MathUtil;
import com.ventooth.beddium.Share;
import com.ventooth.beddium.modules.TerrainRendering.fog.FogState;
import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public final class FogGL {
    private static final FloatBuffer tempBuf = BufferUtils.createFloatBuffer((int)16);

    private FogGL() {
        throw new UnsupportedOperationException();
    }

    public static void read() {
        FogState.enabled = GL11.glGetBoolean((int)2912);
        FogState.mode = GL11.glGetInteger((int)2917);
        GL11.glGetFloatv((int)2918, (FloatBuffer)tempBuf);
        FogState.red = tempBuf.get(0);
        FogState.green = tempBuf.get(1);
        FogState.blue = tempBuf.get(2);
        FogState.start = GL11.glGetFloat((int)2915);
        FogState.end = GL11.glGetFloat((int)2916);
        FogState.density = GL11.glGetFloat((int)2914);
    }

    public static void write() {
        if (FogState.enabled) {
            GL11.glEnable((int)2912);
        } else {
            GL11.glDisable((int)2912);
        }
        GL11.glFogi((int)2917, (int)FogState.mode);
        tempBuf.put(0, FogState.red);
        tempBuf.put(1, FogState.green);
        tempBuf.put(2, FogState.blue);
        GL11.glFogfv((int)2918, (FloatBuffer)tempBuf);
        GL11.glFogf((int)2915, (float)FogState.start);
        GL11.glFogf((int)2916, (float)FogState.end);
        GL11.glFogf((int)2914, (float)FogState.density);
    }

    public static void debug(int pass) {
        Share.log.info("Fog Debug for pass: {}", new Object[]{pass});
        int mismatches = 0;
        boolean enabled = GL11.glGetBoolean((int)2912);
        if (FogState.enabled == enabled) {
            Share.log.info("FogState.enabled=[{}]", new Object[]{enabled});
        } else {
            Share.log.error("FogState.enabled=[{}] != GL.enabled=[{}]", new Object[]{FogState.enabled, enabled});
            ++mismatches;
        }
        int mode = GL11.glGetInteger((int)2917);
        if (FogState.mode == mode) {
            Share.log.info("FogState.mode=[{}]", new Object[]{mode});
        } else {
            Share.log.error("FogState.mode=[{}] != GL.mode=[{}]", new Object[]{FogState.mode, mode});
            ++mismatches;
        }
        GL11.glGetFloatv((int)2918, (FloatBuffer)tempBuf);
        float red = tempBuf.get(0);
        if (MathUtil.epsilonEquals((float)FogState.red, (float)red)) {
            Share.log.info("FogState.red=[{}]", new Object[]{Float.valueOf(red)});
        } else {
            Share.log.error("FogState.red=[{}] != GL.red=[{}]", new Object[]{Float.valueOf(FogState.red), Float.valueOf(red)});
            ++mismatches;
        }
        float green = tempBuf.get(1);
        if (MathUtil.epsilonEquals((float)FogState.green, (float)green)) {
            Share.log.info("FogState.green=[{}]", new Object[]{Float.valueOf(green)});
        } else {
            Share.log.error("FogState.green=[{}] != GL.green=[{}]", new Object[]{Float.valueOf(FogState.green), Float.valueOf(green)});
            ++mismatches;
        }
        float blue = tempBuf.get(2);
        if (MathUtil.epsilonEquals((float)FogState.blue, (float)blue)) {
            Share.log.info("FogState.blue=[{}]", new Object[]{Float.valueOf(blue)});
        } else {
            Share.log.error("FogState.blue=[{}] != GL.blue=[{}]", new Object[]{Float.valueOf(FogState.blue), Float.valueOf(blue)});
            ++mismatches;
        }
        float start = GL11.glGetFloat((int)2915);
        if (MathUtil.epsilonEquals((float)FogState.start, (float)start)) {
            Share.log.info("FogState.start=[{}]", new Object[]{Float.valueOf(start)});
        } else {
            Share.log.error("FogState.start=[{}] != GL.start=[{}]", new Object[]{Float.valueOf(FogState.start), Float.valueOf(start)});
            ++mismatches;
        }
        float end = GL11.glGetFloat((int)2916);
        if (MathUtil.epsilonEquals((float)FogState.end, (float)end)) {
            Share.log.info("FogState.end=[{}]", new Object[]{Float.valueOf(end)});
        } else {
            Share.log.error("FogState.end=[{}] != GL.end=[{}]", new Object[]{Float.valueOf(FogState.end), Float.valueOf(end)});
            ++mismatches;
        }
        float density = GL11.glGetFloat((int)2914);
        if (MathUtil.epsilonEquals((float)FogState.density, (float)density)) {
            Share.log.info("FogState.density=[{}]", new Object[]{Float.valueOf(density)});
        } else {
            Share.log.error("FogState.density=[{}] != GL.density=[{}]", new Object[]{Float.valueOf(FogState.density), Float.valueOf(density)});
            ++mismatches;
        }
        if (mismatches == 0) {
            Share.log.info("FogState Valid");
        } else {
            Share.log.error("FogState mismatch on: [{}] elements", new Object[]{mismatches});
        }
    }

    public static void glFog(int pname, FloatBuffer params) {
        if (pname == 2918) {
            FogState.red = params.get(0);
            FogState.green = params.get(1);
            FogState.blue = params.get(2);
        }
    }

    public static void glFogf(int pname, float param) {
        switch (pname) {
            case 2916: {
                FogState.end = param;
                break;
            }
            case 2915: {
                FogState.start = param;
                break;
            }
            case 2914: {
                FogState.density = param;
            }
        }
    }

    public static void glEnable(int cap) {
        if (cap == 2912) {
            FogState.enabled = true;
        }
    }

    public static void glDisable(int cap) {
        if (cap == 2912) {
            FogState.enabled = false;
        }
    }

    public static void glFogi(int pname, int param) {
        if (pname == 2917) {
            FogState.mode = param;
        }
    }
}

