/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.beddium.modules.TerrainRendering.cache;

import com.ventooth.beddium.api.cache.CachedArrays;
import com.ventooth.beddium.api.cache.CachedArraysFactory;
import com.ventooth.beddium.modules.TerrainRendering.cache.CachedArraysVanillaLight;
import it.unimi.dsi.fastutil.objects.AbstractObjectList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ServiceLoader;
import java.util.concurrent.locks.ReentrantLock;

public class ArrayCache {
    private static final CachedArraysFactory FACTORY;
    private final int maxCacheSize;
    private final AbstractObjectList<CachedArrays> cache;
    private final ReentrantLock MUTEX = new ReentrantLock();

    public ArrayCache(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
        this.cache = new ObjectArrayList(maxCacheSize);
    }

    public CachedArrays allocate(int size) {
        CachedArrays arr;
        while (!this.MUTEX.tryLock()) {
            Thread.yield();
        }
        try {
            arr = this.cache.isEmpty() ? null : (CachedArrays)this.cache.pop();
        }
        finally {
            this.MUTEX.unlock();
        }
        if (arr != null && arr.capacity >= size) {
            return arr;
        }
        return FACTORY.create(size);
    }

    public void free(CachedArrays arr) {
        if (arr != null) {
            arr.reset();
            while (!this.MUTEX.tryLock()) {
                Thread.yield();
            }
            try {
                if (this.cache.size() < this.maxCacheSize) {
                    this.cache.push((Object)arr);
                }
            }
            finally {
                this.MUTEX.unlock();
            }
        }
    }

    static {
        ServiceLoader<CachedArraysFactory> loader = ServiceLoader.load(CachedArraysFactory.class);
        loader.reload();
        FACTORY = loader.findFirst().orElse(CachedArraysVanillaLight::new);
    }
}

