/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.beddium.modules.TerrainRendering;

import com.ventooth.beddium.Share;
import com.ventooth.beddium.config.ModuleConfig;
import com.ventooth.beddium.config.TerrainRenderingConfig;
import com.ventooth.beddium.modules.TerrainRendering.CeleritasWorldRenderer;
import com.ventooth.beddium.modules.TerrainRendering.command.FogDebugCommand;
import com.ventooth.beddium.modules.TerrainRendering.command.ToggleMapCommand;
import com.ventooth.beddium.modules.TerrainRendering.command.TogglePassCommand;
import com.ventooth.beddium.modules.TerrainRendering.command.ToggleWireframeCommand;
import com.ventooth.beddium.modules.TerrainRendering.ext.RenderGlobalExt;
import com.ventooth.beddium.modules.TerrainRendering.fog.FogEvents;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.command.ICommand;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import org.embeddedt.embeddium.api.util.ColorABGR;
import org.embeddedt.embeddium.impl.gl.device.GLRenderDevice;
import org.embeddedt.embeddium.impl.gl.device.RenderDevice;
import org.embeddedt.embeddium.impl.render.chunk.sprite.SpriteTransparencyLevel;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15C;

public final class TerrainRenderingModule {
    private static final AtomicInteger chunkUpdateCounter = new AtomicInteger(0);
    private static final ObjectSet<String> alwaysTranslucentSprites = new ObjectArraySet();
    public static boolean DEBUG_WIREFRAME_MODE = false;

    public static void init() {
        GLRenderDevice.VANILLA_STATE_RESETTER = () -> GL15C.glBindBuffer((int)34962, (int)0);
        if (ModuleConfig.Debug || ((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue()) {
            ClientCommandHandler.instance.func_71560_a((ICommand)new TogglePassCommand());
            ClientCommandHandler.instance.func_71560_a((ICommand)new ToggleWireframeCommand());
            ClientCommandHandler.instance.func_71560_a((ICommand)new ToggleMapCommand());
            ClientCommandHandler.instance.func_71560_a((ICommand)new FogDebugCommand());
        }
        MinecraftForge.EVENT_BUS.register((Object)new TerrainRenderingModule());
        MinecraftForge.EVENT_BUS.register((Object)new FogEvents());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        RenderGlobalExt rgExt;
        CeleritasWorldRenderer renderer;
        if (Minecraft.func_71410_x().field_71441_e != event.world) {
            return;
        }
        RenderGlobal rg = Minecraft.func_71410_x().field_71438_f;
        if (rg instanceof RenderGlobalExt && (renderer = (rgExt = (RenderGlobalExt)rg).celeritas$worldRenderer()) != null) {
            RenderDevice.enterManagedCode();
            try {
                renderer.setWorld(null);
            }
            finally {
                RenderDevice.exitManagedCode();
            }
        }
    }

    @SubscribeEvent
    public void refreshAlwaysTranslucentSprites(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() == 0) {
            List<String> list = Arrays.asList(TerrainRenderingConfig.AlwaysTranslucentSprites);
            alwaysTranslucentSprites.clear();
            alwaysTranslucentSprites.addAll(list);
            list.forEach(name -> Share.log.debug("Sprite: [{}] marked as always translucent", new Object[]{name}));
        }
    }

    public static void incrementChunkUpdateCounter() {
        chunkUpdateCounter.getAndIncrement();
    }

    public static int readChunkUpdateCounter() {
        return chunkUpdateCounter.getAndSet(0);
    }

    public static void toggleWireframe(boolean enable) {
        if (enable) {
            GL11.glPolygonMode((int)1028, (int)6913);
            GL11.glPolygonMode((int)1029, (int)6913);
        } else {
            GL11.glPolygonMode((int)1028, (int)6914);
            GL11.glPolygonMode((int)1029, (int)6914);
        }
    }

    public static SpriteTransparencyLevel getSpriteTranslucencyLevel(String name, int[] nativeImage) {
        if (alwaysTranslucentSprites.contains((Object)name)) {
            return SpriteTransparencyLevel.TRANSLUCENT;
        }
        SpriteTransparencyLevel level = SpriteTransparencyLevel.OPAQUE;
        for (int y = 0; y < nativeImage.length; ++y) {
            int color = nativeImage[y];
            int alpha = ColorABGR.unpackAlpha(color);
            if (alpha > 0) {
                if (alpha < 255) {
                    level = level.chooseNextLevel(SpriteTransparencyLevel.TRANSLUCENT);
                    continue;
                }
                level = level.chooseNextLevel(SpriteTransparencyLevel.OPAQUE);
                continue;
            }
            level = level.chooseNextLevel(SpriteTransparencyLevel.TRANSPARENT);
        }
        return level;
    }

    @Generated
    private TerrainRenderingModule() {
    }
}

