/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.beddium.modules.TerrainRendering;

import com.ventooth.beddium.Compat;
import com.ventooth.beddium.api.task.ChunkTaskProvider;
import com.ventooth.beddium.api.task.ChunkTaskRegistry;
import com.ventooth.beddium.modules.ConservativeAnimatedTextures.ConservativeAnimatedTexturesModule;
import com.ventooth.beddium.modules.MEGAChunks.MegaChunkMetadata;
import com.ventooth.beddium.modules.TerrainRendering.ArchaicRenderPassConfigurationBuilder;
import com.ventooth.beddium.modules.TerrainRendering.compile.ArchaicChunkBuildContext;
import com.ventooth.beddium.modules.TerrainRendering.render.CompatibleChunkRenderer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.embeddedt.embeddium.impl.gl.device.CommandList;
import org.embeddedt.embeddium.impl.render.chunk.RenderPassConfiguration;
import org.embeddedt.embeddium.impl.render.chunk.RenderSection;
import org.embeddedt.embeddium.impl.render.chunk.RenderSectionManager;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkBuildOutput;
import org.embeddedt.embeddium.impl.render.chunk.compile.tasks.ChunkBuilderTask;
import org.embeddedt.embeddium.impl.render.chunk.lists.SectionTicker;
import org.embeddedt.embeddium.impl.render.chunk.lists.SortedRenderLists;
import org.embeddedt.embeddium.impl.render.chunk.occlusion.AsyncOcclusionMode;
import org.embeddedt.embeddium.impl.render.chunk.sprite.GenericSectionSpriteTicker;
import org.embeddedt.embeddium.impl.render.viewport.Viewport;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3ic;

public class ArchaicRenderSectionManager
extends RenderSectionManager {
    private static final boolean USE_ASYNC_OCCLUSION = true;
    private static final boolean USE_FOG_OCCLUSION = true;
    private final WorldClient world;
    private final boolean alwaysDeferChunkUpdates;
    private boolean bypassShadowPass = false;

    public ArchaicRenderSectionManager(RenderPassConfiguration<?> configuration, WorldClient world, int renderDistance, CommandList commandList, int minSection, int maxSection, int requestedThreads, boolean alwaysDeferChunkUpdates) {
        super(configuration, () -> new ArchaicChunkBuildContext(world, configuration), CompatibleChunkRenderer::get, renderDistance, commandList, minSection, maxSection, requestedThreads, Compat.shadowPassExists());
        this.world = world;
        this.alwaysDeferChunkUpdates = alwaysDeferChunkUpdates;
    }

    public static ArchaicRenderSectionManager create(WorldClient world, int renderDistance, CommandList commandList) {
        ChunkTaskProvider provider = ChunkTaskRegistry.getProvider();
        return new ArchaicRenderSectionManager(ArchaicRenderPassConfigurationBuilder.build(), world, renderDistance, commandList, 0, 16 / MegaChunkMetadata.EBS_PER_WR_EDGE, provider.threadCount(), provider.alwaysDeferChunkUpdates());
    }

    @Override
    protected AsyncOcclusionMode getAsyncOcclusionMode() {
        if (Compat.isSwansongInitialized() && Compat.shadowPassExists()) {
            return AsyncOcclusionMode.ONLY_SHADOW;
        }
        return AsyncOcclusionMode.EVERYTHING;
    }

    @Override
    protected boolean shouldRespectUpdateTaskQueueSizeLimit() {
        return true;
    }

    @Override
    protected boolean useFogOcclusion() {
        return true;
    }

    @Override
    protected boolean shouldUseOcclusionCulling(Viewport positionedViewport, boolean spectator) {
        if (Compat.isSwansongInitialized() && Compat.shadowPassActive()) {
            return false;
        }
        Vector3ic camBlockPos = positionedViewport.getBlockCoord();
        boolean useOcclusionCulling = !spectator || !this.world.func_147439_a(camBlockPos.x(), camBlockPos.y(), camBlockPos.z()).func_149662_c();
        return useOcclusionCulling;
    }

    @Override
    protected boolean isSectionVisuallyEmpty(int x, int y, int z) {
        boolean hasBlocks = false;
        x *= MegaChunkMetadata.EBS_PER_WR_EDGE;
        y *= MegaChunkMetadata.EBS_PER_WR_EDGE;
        z *= MegaChunkMetadata.EBS_PER_WR_EDGE;
        for (int cX = 0; cX < MegaChunkMetadata.EBS_PER_WR_EDGE; ++cX) {
            int X = x + cX;
            for (int cZ = 0; cZ < MegaChunkMetadata.EBS_PER_WR_EDGE; ++cZ) {
                int Z = z + cZ;
                Chunk chunk = this.world.func_72964_e(X, Z);
                if (chunk.func_76621_g()) {
                    return true;
                }
                ExtendedBlockStorage[] array = chunk.func_76587_i();
                for (int cY = 0; cY < MegaChunkMetadata.EBS_PER_WR_EDGE; ++cY) {
                    int Y = y + cY;
                    if (Y < 0 || Y >= array.length || array[Y] == null || array[Y].func_76663_a()) continue;
                    hasBlocks = true;
                }
            }
        }
        return !hasBlocks;
    }

    @Override
    @Nullable
    protected ChunkBuilderTask<ChunkBuildOutput> createRebuildTask(RenderSection render, int frame) {
        if (this.isSectionVisuallyEmpty(render.getChunkX(), render.getChunkY(), render.getChunkZ())) {
            return null;
        }
        return ChunkTaskRegistry.getProvider().createRebuildTask(render, frame, this.cameraPosition);
    }

    @Override
    protected boolean allowImportantRebuilds() {
        return this.alwaysDeferChunkUpdates;
    }

    @Override
    @Nullable
    protected SectionTicker createSectionTicker() {
        return new GenericSectionSpriteTicker<TextureAtlasSprite>(ConservativeAnimatedTexturesModule::markSpriteActive);
    }

    public SortedRenderLists getNonShadowRenderLists() {
        this.bypassShadowPass = true;
        SortedRenderLists renderLists = this.getRenderLists();
        this.bypassShadowPass = false;
        return renderLists;
    }

    @Override
    public boolean isInShadowPass() {
        if (this.bypassShadowPass) {
            return false;
        }
        return Compat.isSwansongInitialized() && Compat.shadowPassActive();
    }
}

