/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.beddium.modules.MEGAChunks;

import com.ventooth.beddium.modules.MEGAChunks.MegaChunkMetadata;
import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.BitSet;
import org.embeddedt.embeddium.impl.render.chunk.occlusion.VisibilityEncoding;

public class MEGASectionVisibilityBuilder {
    private static final int SECTION_AXIS_SIZE = MegaChunkMetadata.BLOCKS_PER_WR_EDGE;
    private static final int SECTION_AXIS_MASK = SECTION_AXIS_SIZE - 1;
    private static final int TOTAL_BLOCKS = SECTION_AXIS_SIZE * SECTION_AXIS_SIZE * SECTION_AXIS_SIZE;
    private static final int BLOCKS_ON_ONE_FACE = SECTION_AXIS_SIZE * SECTION_AXIS_SIZE;
    private static final int BITS_PER_AXIS;
    private static final int X_SHIFT = 0;
    private static final int Z_SHIFT;
    private static final int Y_SHIFT;
    private static final int[] INDICES_TO_INITIATE_FLOODFILL;
    private final BitSet blocks = new BitSet(SECTION_AXIS_SIZE * SECTION_AXIS_SIZE * SECTION_AXIS_SIZE);

    private static int[] buildFloodfillIndices() {
        IntArrayList indicesList = new IntArrayList(TOTAL_BLOCKS - (SECTION_AXIS_SIZE - 2) * (SECTION_AXIS_SIZE - 2) * (SECTION_AXIS_SIZE - 2));
        for (int x = 0; x < SECTION_AXIS_SIZE; ++x) {
            for (int z = 0; z < SECTION_AXIS_SIZE; ++z) {
                for (int y = 0; y < SECTION_AXIS_SIZE; ++y) {
                    if (x != 0 && x != SECTION_AXIS_SIZE - 1 && y != 0 && y != SECTION_AXIS_SIZE - 1 && z != 0 && z != SECTION_AXIS_SIZE - 1) continue;
                    indicesList.add(MEGASectionVisibilityBuilder.getIndex(x, y, z));
                }
            }
        }
        return indicesList.toIntArray();
    }

    public long computeVisibilityEncoding() {
        int opaqueCount = this.blocks.cardinality();
        if (opaqueCount == TOTAL_BLOCKS) {
            return 0L;
        }
        if (opaqueCount < BLOCKS_ON_ONE_FACE) {
            return VisibilityEncoding.EVERYTHING;
        }
        return this.computeWithFloodFill();
    }

    public void markOpaque(int x, int y, int z) {
        this.blocks.set(MEGASectionVisibilityBuilder.getIndex(x & MegaChunkMetadata.BLOCKS_PER_WR_EDGE_BITMASK, y & MegaChunkMetadata.BLOCKS_PER_WR_EDGE_BITMASK, z & MegaChunkMetadata.BLOCKS_PER_WR_EDGE_BITMASK));
    }

    private long computeWithFloodFill() {
        long resultEncoding = 0L;
        BitSet blocks = this.blocks;
        BitSet escapedFaces = new BitSet(6);
        IntArrayFIFOQueue queue = new IntArrayFIFOQueue();
        for (int i : INDICES_TO_INITIATE_FLOODFILL) {
            if (blocks.get(i)) continue;
            escapedFaces.clear();
            queue.clear();
            this.exploreFrom(escapedFaces, queue, i);
            int dir = escapedFaces.nextSetBit(0);
            while (dir >= 0) {
                int dir2 = escapedFaces.nextSetBit(0);
                while (dir2 >= 0) {
                    resultEncoding |= 1L << dir * 8 + dir2;
                    dir2 = escapedFaces.nextSetBit(dir2 + 1);
                }
                dir = escapedFaces.nextSetBit(dir + 1);
            }
        }
        return resultEncoding;
    }

    private void exploreFrom(BitSet escapedFaces, IntArrayFIFOQueue queue, int startIndex) {
        queue.enqueue(startIndex);
        BitSet blocks = this.blocks;
        blocks.set(startIndex, true);
        while (!queue.isEmpty()) {
            int idx = queue.dequeueInt();
            for (int dir = 0; dir < 6; ++dir) {
                int neighborIdx = MEGASectionVisibilityBuilder.getNeighborIndex(idx, dir);
                if (neighborIdx >= 0) {
                    if (blocks.get(neighborIdx)) continue;
                    blocks.set(neighborIdx, true);
                    queue.enqueue(neighborIdx);
                    continue;
                }
                escapedFaces.set(dir);
            }
        }
    }

    private static int getNeighborIndex(int idx, int dir) {
        switch (dir) {
            case 1: {
                if ((idx >> Y_SHIFT & SECTION_AXIS_MASK) == SECTION_AXIS_MASK) {
                    return -1;
                }
                return idx + (1 << Y_SHIFT);
            }
            case 0: {
                if ((idx >> Y_SHIFT & SECTION_AXIS_MASK) == 0) {
                    return -1;
                }
                return idx - (1 << Y_SHIFT);
            }
            case 5: {
                if ((idx >> 0 & SECTION_AXIS_MASK) == SECTION_AXIS_MASK) {
                    return -1;
                }
                return idx + 1;
            }
            case 4: {
                if ((idx >> 0 & SECTION_AXIS_MASK) == 0) {
                    return -1;
                }
                return idx - 1;
            }
            case 3: {
                if ((idx >> Z_SHIFT & SECTION_AXIS_MASK) == SECTION_AXIS_MASK) {
                    return -1;
                }
                return idx + (1 << Z_SHIFT);
            }
            case 2: {
                if ((idx >> Z_SHIFT & SECTION_AXIS_MASK) == 0) {
                    return -1;
                }
                return idx - (1 << Z_SHIFT);
            }
        }
        throw new IllegalArgumentException();
    }

    private static int getIndex(int x, int y, int z) {
        return y << Y_SHIFT | z << Z_SHIFT | x << 0;
    }

    static {
        Z_SHIFT = BITS_PER_AXIS = MegaChunkMetadata.BLOCKS_PER_WR_EDGE_BITS;
        Y_SHIFT = BITS_PER_AXIS * 2;
        INDICES_TO_INITIATE_FLOODFILL = MEGASectionVisibilityBuilder.buildFloodfillIndices();
    }
}

