/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.beddium.modules.MEGAChunks;

import com.ventooth.beddium.modules.MEGAChunks.MegaChunkMetadata;
import com.ventooth.beddium.modules.TerrainRendering.SafeChunkTracker;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import org.embeddedt.embeddium.impl.render.chunk.map.ChunkTracker;
import org.embeddedt.embeddium.impl.util.PositionUtil;

public sealed interface MEGAChunkTracker {
    public static final long ALL_BITS_ALL;

    private static long getAllBitsAll() {
        long accum = 0L;
        for (int z = 0; z < MegaChunkMetadata.EBS_PER_WR_EDGE; ++z) {
            for (int x = 0; x < MegaChunkMetadata.EBS_PER_WR_EDGE; ++x) {
                accum |= MEGAChunkTracker.shiftTo(x, z);
            }
        }
        return accum;
    }

    private static long shiftTo(int x, int z) {
        int subX = x & MegaChunkMetadata.EBS_PER_WR_EDGE_BITMASK;
        int subZ = z & MegaChunkMetadata.EBS_PER_WR_EDGE_BITMASK;
        int offset = subX + (subZ << MegaChunkMetadata.EBS_PER_WR_EDGE_BITS);
        return 1L << offset;
    }

    public Long2LongMap subChunkStatus();

    default public void onChunkStatusAddedMEGA(int x, int z, int flags) {
        long cur;
        if (!1.$assertionsDisabled && flags != 3) {
            throw new AssertionError();
        }
        int wX = x >> MegaChunkMetadata.EBS_PER_WR_EDGE_BITS;
        int wZ = z >> MegaChunkMetadata.EBS_PER_WR_EDGE_BITS;
        long sFlags = MEGAChunkTracker.shiftTo(x, z);
        long key = PositionUtil.packChunk(wX, wZ);
        long prev = this.subChunkStatus().get(key);
        if (prev == (cur = prev | sFlags)) {
            return;
        }
        this.subChunkStatus().put(key, cur);
        if (cur == ALL_BITS_ALL) {
            this.onChunkStatusAddedImpl(wX, wZ, 3);
        }
    }

    default public void onChunkStatusRemovedMEGA(int x, int z, int flags) {
        long cur;
        if (!1.$assertionsDisabled && flags != 3) {
            throw new AssertionError();
        }
        int wX = x >> MegaChunkMetadata.EBS_PER_WR_EDGE_BITS;
        int wZ = z >> MegaChunkMetadata.EBS_PER_WR_EDGE_BITS;
        long sFlags = MEGAChunkTracker.shiftTo(x, z);
        long key = PositionUtil.packChunk(wX, wZ);
        long prev = this.subChunkStatus().get(key);
        if (prev == (cur = prev & (sFlags ^ 0xFFFFFFFFFFFFFFFFL))) {
            return;
        }
        if (cur == this.subChunkStatus().defaultReturnValue()) {
            this.subChunkStatus().remove(key);
        } else {
            this.subChunkStatus().put(key, cur);
        }
        if (prev == ALL_BITS_ALL) {
            this.onChunkStatusRemovedImpl(wX, wZ, 3);
        }
    }

    public void onChunkStatusAddedImpl(int var1, int var2, int var3);

    public void onChunkStatusRemovedImpl(int var1, int var2, int var3);

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        ALL_BITS_ALL = MEGAChunkTracker.getAllBitsAll();
    }

    public static final class Vanilla
    extends SafeChunkTracker
    implements MEGAChunkTracker {
        private final Long2LongMap subChunkStatus = new Long2LongOpenHashMap();

        @Override
        public Long2LongMap subChunkStatus() {
            return this.subChunkStatus;
        }

        @Override
        public void onChunkStatusAddedImpl(int x, int z, int flags) {
            super.onChunkStatusAdded(x, z, flags);
        }

        @Override
        public void onChunkStatusRemovedImpl(int x, int z, int flags) {
            super.onChunkStatusRemoved(x, z, flags);
        }

        @Override
        public void onChunkStatusAdded(int x, int z, int flags) {
            this.onChunkStatusAddedMEGA(x, z, flags);
        }

        @Override
        public void onChunkStatusRemoved(int x, int z, int flags) {
            this.onChunkStatusRemovedMEGA(x, z, flags);
        }
    }

    public static final class Fast
    extends ChunkTracker
    implements MEGAChunkTracker {
        private final Long2LongMap subChunkStatus = new Long2LongOpenHashMap();

        @Override
        public Long2LongMap subChunkStatus() {
            return this.subChunkStatus;
        }

        @Override
        public void onChunkStatusAddedImpl(int x, int z, int flags) {
            super.onChunkStatusAdded(x, z, flags);
        }

        @Override
        public void onChunkStatusRemovedImpl(int x, int z, int flags) {
            super.onChunkStatusRemoved(x, z, flags);
        }

        @Override
        public void onChunkStatusAdded(int x, int z, int flags) {
            this.onChunkStatusAddedMEGA(x, z, flags);
        }

        @Override
        public void onChunkStatusRemoved(int x, int z, int flags) {
            this.onChunkStatusRemovedMEGA(x, z, flags);
        }
    }
}

