/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.beddium.api.cache;

import com.ventooth.beddium.api.cache.BiomeColorCacheCapable;
import com.ventooth.beddium.api.cache.CachedArrays;
import com.ventooth.beddium.api.cache.StateAwareCache;
import com.ventooth.beddium.api.task.WorldRenderRegion;
import com.ventooth.beddium.config.TerrainRenderingConfig;
import com.ventooth.beddium.modules.BiomeColorCache.BiomeColorCacheImpl;
import com.ventooth.beddium.modules.BiomeColorCache.BiomeColorType;
import com.ventooth.beddium.modules.TerrainRendering.cache.ArrayCache;
import net.minecraft.block.Block;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import org.embeddedt.embeddium.impl.biome.BiomeColorCache;

public class SimpleChunkCache
extends ChunkCache
implements BiomeColorCacheCapable,
StateAwareCache {
    private final BiomeColorCacheImpl biomeColorCache;
    private final int posX;
    private final int posY;
    private final int posZ;
    private CachedArrays cache;
    private static final ArrayCache arrayCache = new ArrayCache(16);
    private static final int EDGE_SIZE = (1 << TerrainRenderingConfig.MEGAChunks) * 16 + 4;
    private static final int ARRAY_SIZE = EDGE_SIZE * EDGE_SIZE * EDGE_SIZE;

    public SimpleChunkCache(World world, WorldRenderRegion region) {
        this(world, region.minX, region.minY, region.minZ, region.maxX, region.maxY, region.maxZ);
    }

    public SimpleChunkCache(World world, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        super(world, minX, minY, minZ, maxX, maxY, maxZ, 1);
        this.posX = minX - 1;
        this.posY = minY - 1;
        this.posZ = minZ - 1;
        this.biomeColorCache = new BiomeColorCacheImpl((IBlockAccess)this);
    }

    public int func_72802_i(int x, int y, int z, int lightValue) {
        int index;
        if (this.cache != null && (index = this.getPositionIndex(x, y, z)) >= 0 && index < this.cache.capacity) {
            int light = this.cache.getLight(index);
            if (light == -1) {
                light = this.getLightBrightnessForSkyBlocksUncached(x, y, z, lightValue);
                this.cache.putLight(index, light);
            }
            return light;
        }
        return this.getLightBrightnessForSkyBlocksUncached(x, y, z, lightValue);
    }

    protected int getLightBrightnessForSkyBlocksUncached(int x, int y, int z, int lightValue) {
        return super.func_72802_i(x, y, z, lightValue);
    }

    public Block func_147439_a(int x, int y, int z) {
        if (this.cache != null) {
            Block[] blocks = this.cache.block;
            int index = this.getPositionIndex(x, y, z);
            if (index >= 0 && index < blocks.length) {
                Block block = blocks[index];
                if (block == null) {
                    blocks[index] = block = this.getBlockUncached(x, y, z);
                }
                return block;
            }
        }
        return this.getBlockUncached(x, y, z);
    }

    protected Block getBlockUncached(int x, int y, int z) {
        return super.func_147439_a(x, y, z);
    }

    public int func_72805_g(int x, int y, int z) {
        if (this.cache != null) {
            int[] metas = this.cache.meta;
            int index = this.getPositionIndex(x, y, z);
            if (index >= 0 && index < metas.length) {
                int meta = metas[index];
                if (meta == -1) {
                    metas[index] = meta = this.getBlockMetadataUncached(x, y, z);
                }
                return meta;
            }
        }
        return this.getBlockMetadataUncached(x, y, z);
    }

    protected int getBlockMetadataUncached(int x, int y, int z) {
        return super.func_72805_g(x, y, z);
    }

    public boolean func_147437_c(int x, int y, int z) {
        if (this.cache != null) {
            byte[] airs = this.cache.air;
            int index = this.getPositionIndex(x, y, z);
            if (index >= 0 && index < airs.length) {
                int air = airs[index];
                if (air == 0) {
                    airs[index] = air = this.isAirBlockUncached(x, y, z) ? 2 : 1;
                }
                return air == 2;
            }
        }
        return this.isAirBlockUncached(x, y, z);
    }

    protected boolean isAirBlockUncached(int x, int y, int z) {
        return super.func_147437_c(x, y, z);
    }

    private int getPositionIndex(int x, int y, int z) {
        int i = x - this.posX;
        int j = y - this.posY;
        int k = z - this.posZ;
        return i >= 0 && j >= 0 && k >= 0 && i < EDGE_SIZE && j < EDGE_SIZE && k < EDGE_SIZE ? i * (EDGE_SIZE * EDGE_SIZE) + k * EDGE_SIZE + j : -1;
    }

    @Override
    public void renderStart() {
        if (this.cache == null) {
            this.cache = arrayCache.allocate(ARRAY_SIZE);
        } else {
            this.cache.reset();
        }
    }

    @Override
    public void renderFinish() {
        arrayCache.free(this.cache);
    }

    @Override
    public BiomeColorCache<BiomeGenBase, BiomeColorType> celeritas$biomeCache() {
        return this.biomeColorCache;
    }
}

