/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.data;

import cpw.mods.fml.common.Loader;
import foxie.calendar.api.CalendarAPI;
import foxie.calendar.api.ICalendarProvider;
import foxie.calendar.api.ISeasonProvider;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraftforge.common.DimensionManager;
import org.blockartistry.mod.DynSurround.ModLog;
import org.blockartistry.mod.DynSurround.ModOptions;
import org.blockartistry.mod.DynSurround.Module;
import org.blockartistry.mod.DynSurround.data.config.DimensionConfig;
import org.blockartistry.mod.DynSurround.util.DiurnalUtils;

public final class DimensionRegistry
implements Comparable<DimensionRegistry> {
    private static final int SPACE_HEIGHT_OFFSET = 32;
    private static final boolean CALENDAR_API = Loader.isModLoaded((String)"CalendarAPI");
    private static final String SEASON_NOT_AVAILABLE = "noseason";
    private static final List<DimensionConfig.Entry> cache = new ArrayList<DimensionConfig.Entry>();
    private static final TIntObjectHashMap<DimensionRegistry> dimensionData = new TIntObjectHashMap();
    private static boolean isFlatWorld = false;
    private final int dimensionId;
    private boolean initialized;
    private String name = "<NOT SET>";
    private Integer seaLevel;
    private Integer skyHeight;
    private Integer cloudHeight;
    private Integer spaceHeight;
    private Boolean hasHaze;
    private Boolean hasAuroras;
    private Boolean hasWeather;
    private static final String CONDITION_TOKEN_RAINING = "raining";
    private static final String CONDITION_TOKEN_DAY = "day";
    private static final String CONDITION_TOKEN_NIGHT = "night";
    private static final char CONDITION_SEPARATOR = '#';

    public static void initialize() {
        try {
            DimensionRegistry.process(DimensionConfig.load("dimensions"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (String file : ModOptions.dimensionConfigFiles) {
            File theFile = new File(Module.dataDirectory(), file);
            if (theFile.exists()) {
                try {
                    DimensionConfig config = DimensionConfig.load(theFile);
                    if (config != null) {
                        DimensionRegistry.process(config);
                        continue;
                    }
                    ModLog.warn("Unable to process dimension config file " + file, new Object[0]);
                }
                catch (Exception ex) {
                    ModLog.error("Unable to process dimension config file " + file, ex);
                }
                continue;
            }
            ModLog.warn("Could not locate dimension config file [%s]", file);
        }
        ModLog.info("*** DIMENSION REGISTRY (delay init) ***", new Object[0]);
        dimensionData.valueCollection().stream().sorted().forEach(dimensionRegistry -> ModLog.info(dimensionRegistry.toString(), new Object[0]));
    }

    public static void loading(World world) {
        DimensionRegistry.getData(world).initialize(world.field_73011_w);
        if (world.field_73011_w.field_76574_g == 0) {
            isFlatWorld = world.func_72912_H().func_76067_t() == WorldType.field_77138_c;
        }
    }

    private static DimensionConfig.Entry getData(DimensionConfig.Entry entry) {
        for (DimensionConfig.Entry e : cache) {
            if ((e.dimensionId == null || !e.dimensionId.equals(entry.dimensionId)) && (e.name == null || !e.name.equals(entry.name))) continue;
            return e;
        }
        cache.add(entry);
        return entry;
    }

    private static void process(DimensionConfig config) {
        for (DimensionConfig.Entry entry : config.entries) {
            DimensionConfig.Entry data;
            if (entry.dimensionId == null && entry.name == null || (data = DimensionRegistry.getData(entry)) == entry) continue;
            if (data.dimensionId == null) {
                data.dimensionId = entry.dimensionId;
            }
            if (data.name == null) {
                data.name = entry.name;
            }
            if (entry.hasAurora != null) {
                data.hasAurora = entry.hasAurora;
            }
            if (entry.hasHaze != null) {
                data.hasHaze = entry.hasHaze;
            }
            if (entry.hasWeather != null) {
                data.hasWeather = entry.hasWeather;
            }
            if (entry.cloudHeight != null) {
                data.cloudHeight = entry.cloudHeight;
            }
            if (entry.seaLevel != null) {
                data.seaLevel = entry.seaLevel;
            }
            if (entry.skyHeight == null) continue;
            data.skyHeight = entry.skyHeight;
        }
    }

    private DimensionRegistry(World world) {
        this.dimensionId = world.field_73011_w.field_76574_g;
        this.initialize(world.field_73011_w);
    }

    private DimensionRegistry(World world, DimensionConfig.Entry entry) {
        this.dimensionId = world.field_73011_w.field_76574_g;
        this.name = world.field_73011_w.func_80007_l();
        this.seaLevel = entry.seaLevel;
        this.skyHeight = entry.skyHeight;
        this.hasHaze = entry.hasHaze;
        this.hasAuroras = entry.hasAurora;
        this.hasWeather = entry.hasWeather;
        this.cloudHeight = entry.cloudHeight;
        this.initialize(world.field_73011_w);
    }

    private DimensionRegistry initialize(WorldProvider provider) {
        if (!this.initialized) {
            this.name = provider.func_80007_l();
            if (this.seaLevel == null) {
                this.seaLevel = provider.func_76557_i();
            }
            if (this.skyHeight == null) {
                this.skyHeight = provider.getHeight();
            }
            if (this.hasHaze == null) {
                this.hasHaze = !provider.field_76576_e;
            }
            if (this.hasAuroras == null) {
                this.hasAuroras = !provider.field_76576_e;
            }
            if (this.hasWeather == null) {
                this.hasWeather = !provider.field_76576_e;
            }
            if (this.cloudHeight == null) {
                this.cloudHeight = this.hasHaze != false ? this.skyHeight / 2 : this.skyHeight;
            }
            if (this.spaceHeight == null) {
                this.spaceHeight = this.skyHeight + 32;
            }
            this.initialized = true;
            ModLog.info("Dimension initialized " + this, new Object[0]);
        }
        return this;
    }

    public int getDimensionId() {
        return this.dimensionId;
    }

    public String getName() {
        return this.name;
    }

    public int getSeaLevel() {
        return this.seaLevel;
    }

    public int getSkyHeight() {
        return this.skyHeight;
    }

    public int getCloudHeight() {
        return this.cloudHeight;
    }

    public int getSpaceHeight() {
        return this.spaceHeight;
    }

    public boolean getHasHaze() {
        return this.hasHaze;
    }

    public boolean getHasAuroras() {
        return this.hasAuroras;
    }

    public boolean getHasWeather() {
        return this.hasWeather;
    }

    public String getSeason() {
        if (Module.LOTR && this.name.equals("MiddleEarth") && !ModOptions.useNoLotrProxy) {
            return Module.LOTR_PROXY.getSeason();
        }
        if (!CALENDAR_API) {
            return SEASON_NOT_AVAILABLE;
        }
        ISeasonProvider provider = CalendarAPI.getSeasonProvider((int)this.dimensionId);
        if (provider == null) {
            return SEASON_NOT_AVAILABLE;
        }
        WorldServer world = DimensionManager.getWorld((int)this.dimensionId);
        if (world == null) {
            return SEASON_NOT_AVAILABLE;
        }
        ICalendarProvider calendar = CalendarAPI.getCalendarInstance((World)world);
        if (calendar == null) {
            return SEASON_NOT_AVAILABLE;
        }
        return provider.getSeason(calendar).getName();
    }

    public static DimensionRegistry getData(World world) {
        DimensionRegistry data = (DimensionRegistry)dimensionData.get(world.field_73011_w.field_76574_g);
        if (data == null) {
            DimensionConfig.Entry entry = null;
            for (DimensionConfig.Entry e : cache) {
                if ((e.dimensionId == null || e.dimensionId != world.field_73011_w.field_76574_g) && (e.name == null || !e.name.equals(world.field_73011_w.func_80007_l()))) continue;
                entry = e;
                break;
            }
            data = entry == null ? new DimensionRegistry(world) : new DimensionRegistry(world, entry);
            dimensionData.put(world.field_73011_w.field_76574_g, (Object)data);
        }
        return data;
    }

    public static boolean hasHaze(World world) {
        return DimensionRegistry.getData(world).getHasHaze();
    }

    public static int getSeaLevel(World world) {
        if (world.field_73011_w.field_76574_g == 0 && isFlatWorld) {
            return 0;
        }
        return DimensionRegistry.getData(world).getSeaLevel();
    }

    public static int getSkyHeight(World world) {
        return DimensionRegistry.getData(world).getSkyHeight();
    }

    public static int getCloudHeight(World world) {
        return DimensionRegistry.getData(world).getCloudHeight();
    }

    public static int getSpaceHeight(World world) {
        return DimensionRegistry.getData(world).getSpaceHeight();
    }

    public static boolean hasAuroras(World world) {
        return DimensionRegistry.getData(world).getHasAuroras();
    }

    public static boolean hasWeather(World world) {
        return DimensionRegistry.getData(world).getHasWeather();
    }

    public static String getSeason(World world) {
        return DimensionRegistry.getData(world).getSeason();
    }

    public static String getConditions(World world) {
        StringBuilder builder = new StringBuilder();
        builder.append('#');
        if (DiurnalUtils.isDaytime(world)) {
            builder.append(CONDITION_TOKEN_DAY);
        } else {
            builder.append(CONDITION_TOKEN_NIGHT);
        }
        builder.append('#').append(world.field_73011_w.func_80007_l());
        if (world.func_72867_j(1.0f) > 0.0f) {
            builder.append('#').append(CONDITION_TOKEN_RAINING);
        }
        builder.append('#').append(DimensionRegistry.getSeason(world));
        builder.append('#');
        return builder.toString();
    }

    public String toString() {
        return String.valueOf(this.dimensionId) + '/' + this.name + ':' + " seaLevel:" + this.seaLevel + " cloudH:" + this.cloudHeight + " skyH:" + this.skyHeight + " haze:" + this.hasHaze + " aurora:" + this.hasAuroras + " weather:" + this.hasWeather;
    }

    @Override
    public int compareTo(DimensionRegistry e) {
        return this.toString().compareToIgnoreCase(e.toString());
    }
}

