/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.data;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import org.blockartistry.mod.DynSurround.util.INBTSerialization;

public final class AuroraData
implements INBTSerialization {
    public int dimensionId;
    public int posX;
    public int posZ;
    public long seed;
    public int colorSet;
    public int preset;

    public AuroraData() {
    }

    public AuroraData(EntityPlayer player, int zOffset, int colorSet, int preset) {
        this(player.field_70170_p.field_73011_w.field_76574_g, (int)player.field_70165_t, (int)player.field_70161_v + zOffset, player.field_70170_p.func_72820_D(), colorSet, preset);
    }

    public AuroraData(int dimensionId, int x, int z, long seed, int colorSet, int preset) {
        this.dimensionId = dimensionId;
        this.posX = x;
        this.posZ = z;
        this.seed = seed;
        this.colorSet = colorSet;
        this.preset = preset;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.dimensionId = nbt.func_74762_e("d");
        this.posX = nbt.func_74762_e("x");
        this.posZ = nbt.func_74762_e("z");
        this.seed = nbt.func_74763_f("t");
        this.colorSet = nbt.func_74762_e("s");
        this.preset = nbt.func_74762_e("p");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("d", this.dimensionId);
        nbt.func_74768_a("x", this.posX);
        nbt.func_74768_a("z", this.posZ);
        nbt.func_74772_a("t", this.seed);
        nbt.func_74768_a("s", this.colorSet);
        nbt.func_74768_a("p", this.preset);
    }

    public boolean equals(Object anObj) {
        if (!(anObj instanceof AuroraData)) {
            return false;
        }
        AuroraData a = (AuroraData)anObj;
        return this.dimensionId == a.dimensionId && this.posX == a.posX && this.posZ == a.posZ;
    }

    public String toString() {
        return "[x: " + this.posX + ", z: " + this.posZ + ']' + " color: " + this.colorSet + " preset: " + this.preset + " seed: " + this.seed;
    }

    private static final class NBT {
        public static final String DIMENSION = "d";
        public static final String XCOORD = "x";
        public static final String ZCOORD = "z";
        public static final String SEED = "t";
        public static final String COLOR_SET = "s";
        public static final String PRESET = "p";

        private NBT() {
        }
    }
}

