/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client.sound;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundPoolEntry;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import org.blockartistry.mod.DynSurround.ModLog;
import org.blockartistry.mod.DynSurround.ModOptions;
import org.blockartistry.mod.DynSurround.client.EnvironStateHandler;
import org.blockartistry.mod.DynSurround.client.sound.Emitter;
import org.blockartistry.mod.DynSurround.client.sound.SoundEffect;
import org.blockartistry.mod.DynSurround.client.sound.SpotSound;
import org.blockartistry.mod.DynSurround.compat.BlockPos;
import org.blockartistry.mod.DynSurround.data.SoundRegistry;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCdevice;
import paulscode.sound.SoundSystemConfig;

@SideOnly(value=Side.CLIENT)
public class SoundManager {
    private static final int AGE_THRESHOLD_TICKS = 5;
    private static final int SOUND_QUEUE_SLACK = 6;
    private static final Map<SoundEffect, Emitter> emitters = new HashMap<SoundEffect, Emitter>();
    private static final List<SpotSound> pending = new ArrayList<SpotSound>();
    private static int normalChannelCount = 0;
    private static int streamChannelCount = 0;

    public static void clearSounds() {
        for (Emitter emit : emitters.values()) {
            emit.fade();
        }
        emitters.clear();
        pending.clear();
    }

    public static void queueAmbientSounds(List<SoundEffect> sounds) {
        ArrayList<SoundEffect> active = new ArrayList<SoundEffect>(emitters.keySet());
        for (SoundEffect effect : active) {
            if (!sounds.contains(effect)) {
                emitters.remove(effect).fade();
                continue;
            }
            Emitter emitter = emitters.get(effect);
            SoundEffect incoming = null;
            for (SoundEffect sound : sounds) {
                if (!sound.equals(effect)) continue;
                incoming = sound;
                break;
            }
            emitter.setVolume(incoming.getVolume());
            sounds.remove(effect);
        }
        for (SoundEffect sound : sounds) {
            emitters.put(sound, new Emitter(sound));
        }
    }

    public static void update() {
        for (Emitter emitter : emitters.values()) {
            emitter.update();
        }
        Iterator<SpotSound> pitr = pending.iterator();
        while (pitr.hasNext()) {
            SpotSound sound = pitr.next();
            if (sound.getTickAge() >= 5) {
                ModLog.debug("AGING: " + (Object)((Object)sound), new Object[0]);
                pitr.remove();
                continue;
            }
            if (sound.getTickAge() < 0 || !SoundManager.canFitSound()) continue;
            SoundManager.playSound((ISound)sound);
            pitr.remove();
        }
    }

    public static int currentSoundCount() {
        return Minecraft.func_71410_x().func_147118_V().field_147694_f.field_148629_h.size();
    }

    public static int maxSoundCount() {
        return SoundSystemConfig.getNumberNormalChannels() + SoundSystemConfig.getNumberStreamingChannels();
    }

    private static boolean canFitSound() {
        return SoundManager.currentSoundCount() < SoundSystemConfig.getNumberNormalChannels() - 6;
    }

    public static void flushSound() {
        SoundHandler h = Minecraft.func_71410_x().func_147118_V();
        h.field_147694_f.field_148620_e.CommandQueue(null);
    }

    static void playSound(ISound sound) {
        if (sound != null) {
            if (ModOptions.enableDebugLogging) {
                ModLog.debug("PLAYING: " + sound, new Object[0]);
            }
            SoundHandler h = Minecraft.func_71410_x().func_147118_V();
            h.func_147682_a(sound);
        }
    }

    public static void playSoundAtPlayer(SoundEffect sound) {
        SpotSound s = new SpotSound(sound);
        SoundManager.playSound((ISound)s);
    }

    public static void playSoundAtPlayer(EntityPlayer player, SoundEffect sound) {
        if (player == null) {
            player = EnvironStateHandler.EnvironState.getPlayer();
        }
        SpotSound s = new SpotSound(player, sound);
        if (!SoundManager.canFitSound()) {
            pending.add(s);
        } else {
            SoundManager.playSound((ISound)s);
        }
    }

    public static void playSoundAt(BlockPos pos, SoundEffect sound, int tickDelay) {
        if (tickDelay > 0 && !SoundManager.canFitSound()) {
            return;
        }
        SpotSound s = new SpotSound(pos, sound, tickDelay);
        if (tickDelay > 0 || !SoundManager.canFitSound()) {
            pending.add(s);
        } else {
            SoundManager.playSound((ISound)s);
        }
    }

    public static boolean isSoundPlaying(@Nonnull ISound sound) {
        net.minecraft.client.audio.SoundManager manager = Minecraft.func_71410_x().func_147118_V().field_147694_f;
        return manager.func_148597_a(sound) || manager.field_148629_h.containsValue(sound) || manager.field_148626_m.containsKey(sound);
    }

    public static List<String> getSounds() {
        ArrayList<String> result = new ArrayList<String>();
        for (SoundEffect soundEffect : emitters.keySet()) {
            result.add("EMITTER: " + soundEffect.toString() + "[vol:" + emitters.get(soundEffect).getVolume() + "]");
        }
        for (SpotSound spotSound : pending) {
            result.add((spotSound.getTickAge() < 0 ? "DELAYED: " : "PENDING: ") + spotSound.getSoundEffect().toString());
        }
        return result;
    }

    private static float getVolume(@Nonnull SoundCategory category) {
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        return settings != null && category != SoundCategory.MASTER ? settings.func_151438_a(category) : 1.0f;
    }

    public static float getNormalizedVolume(ISound sound, SoundPoolEntry poolEntry, SoundCategory category) {
        float result = 0.0f;
        if (sound == null) {
            ModLog.warn("getNormalizedVolume(): Null sound parameter", new Object[0]);
            return result;
        }
        String soundName = sound.func_147650_b().toString();
        if (poolEntry == null) {
            ModLog.warn("getNormalizedVolume(%s): Null poolEntry parameter", soundName);
        } else if (category == null) {
            ModLog.warn("getNormalizedVolume(%s): Null category parameter", soundName);
        } else {
            try {
                float volumeScale = SoundRegistry.getVolumeScale(soundName);
                result = (float)MathHelper.func_151237_a((double)((double)sound.func_147653_e() * poolEntry.func_148649_c() * (double)SoundManager.getVolume(category) * (double)volumeScale), (double)0.0, (double)1.0);
            }
            catch (Throwable t) {
                ModLog.error("getNormalizedVolume(): Unable to calculate " + soundName, t);
            }
        }
        return result;
    }

    public static float getNormalizedPitch(ISound sound, SoundPoolEntry poolEntry) {
        float result = 0.0f;
        if (sound == null) {
            ModLog.warn("getNormalizedPitch(): Null sound parameter", new Object[0]);
            return result;
        }
        String soundName = sound.func_147650_b().toString();
        if (poolEntry == null) {
            ModLog.warn("getNormalizedPitch(%s): Null poolEntry parameter", soundName);
        } else {
            try {
                result = (float)MathHelper.func_151237_a((double)((double)sound.func_147655_f() * poolEntry.func_148650_b()), (double)0.5, (double)2.0);
            }
            catch (Throwable t) {
                ModLog.error("getNormalizedPitch(): Unable to calculate " + soundName, t);
            }
        }
        return result;
    }

    public static void configureSound() {
        int totalChannels = -1;
        try {
            boolean create;
            boolean bl = create = !AL.isCreated();
            if (create) {
                AL.create();
            }
            IntBuffer ib = BufferUtils.createIntBuffer((int)1);
            ALC10.alcGetInteger((ALCdevice)AL.getDevice(), (int)4112, (IntBuffer)ib);
            totalChannels = ib.get(0);
            if (create) {
                AL.destroy();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        normalChannelCount = ModOptions.normalSoundChannelCount;
        streamChannelCount = ModOptions.streamingSoundChannelCount;
        if (ModOptions.autoConfigureChannels && totalChannels > 64) {
            totalChannels = (totalChannels + 1) * 3 / 4;
            streamChannelCount = totalChannels / 5;
            normalChannelCount = totalChannels - streamChannelCount;
        }
        ModLog.info("Sound channels: %d normal, %d streaming (total avail: %s)", normalChannelCount, streamChannelCount, totalChannels == -1 ? "UNKNOWN" : Integer.toString(totalChannels));
        SoundSystemConfig.setNumberNormalChannels((int)normalChannelCount);
        SoundSystemConfig.setNumberStreamingChannels((int)streamChannelCount);
    }
}

