/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client.sound;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.audio.ISound;
import org.blockartistry.mod.DynSurround.ModLog;
import org.blockartistry.mod.DynSurround.client.sound.PlayerSound;
import org.blockartistry.mod.DynSurround.client.sound.SoundEffect;
import org.blockartistry.mod.DynSurround.client.sound.SoundManager;
import org.blockartistry.mod.DynSurround.util.random.XorShiftRandom;
import paulscode.sound.SoundSystemConfig;

@SideOnly(value=Side.CLIENT)
class Emitter {
    protected static final Random RANDOM = new XorShiftRandom();
    protected final SoundEffect effect;
    protected PlayerSound activeSound;
    protected int repeatDelay = 0;

    public Emitter(SoundEffect sound) {
        this.effect = sound;
    }

    public void update() {
        if (SoundSystemConfig.getMasterGain() <= 0.0f) {
            return;
        }
        if (this.activeSound == null) {
            this.activeSound = new PlayerSound(this.effect);
        } else if (SoundManager.isSoundPlaying((ISound)this.activeSound)) {
            return;
        }
        try {
            SoundManager.playSound((ISound)this.activeSound);
        }
        catch (Throwable t) {
            ModLog.error("Unable to play sound", t);
        }
    }

    public void setVolume(float volume) {
        if (this.activeSound != null) {
            this.activeSound.setVolume(volume);
        }
    }

    public float getVolume() {
        return this.activeSound != null ? this.activeSound.func_147653_e() : 0.0f;
    }

    public void fade() {
        if (this.activeSound != null) {
            this.activeSound.fadeAway();
        }
    }
}

