/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client.fx;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import org.blockartistry.mod.DynSurround.client.fx.BlockEffect;
import org.blockartistry.mod.DynSurround.client.fx.particle.EntityBubbleJetFX;
import org.blockartistry.mod.DynSurround.client.fx.particle.EntityDustJetFX;
import org.blockartistry.mod.DynSurround.client.fx.particle.EntityFireJetFX;
import org.blockartistry.mod.DynSurround.client.fx.particle.EntityFountainJetFX;
import org.blockartistry.mod.DynSurround.client.fx.particle.EntityJetFX;
import org.blockartistry.mod.DynSurround.client.fx.particle.EntitySteamJetFX;
import org.blockartistry.mod.DynSurround.compat.BlockPos;

public abstract class JetEffect
extends BlockEffect {
    private static final int MAX_STRENGTH = 10;

    private static int countBlocks(World world, BlockPos pos, Block block, int dir) {
        int count = 0;
        int idx = pos.getY();
        while (count < 10) {
            if (world.func_147439_a(pos.getX(), idx, pos.getZ()) != block) {
                return count;
            }
            ++count;
            idx += dir;
        }
        return count;
    }

    private static double jetSpawnHeight(World world, BlockPos pos) {
        int meta = world.func_72805_g(pos.getX(), pos.getY(), pos.getZ());
        return 1.1 - (double)BlockLiquid.func_149801_b((int)meta) + (double)pos.getY();
    }

    public JetEffect(int chance) {
        super(chance);
    }

    protected void addEffect(EntityJetFX fx) {
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        fx.playSound();
    }

    public static class Fountain
    extends JetEffect {
        public Fountain(int chance) {
            super(chance);
        }

        @Override
        public boolean trigger(Block block, World world, BlockPos pos, Random random) {
            return super.trigger(block, world, pos, random) && world.func_147437_c(pos.getX(), pos.getY() + 1, pos.getZ());
        }

        @Override
        public void doEffect(Block block, World world, BlockPos pos, Random random) {
            EntityFountainJetFX effect = new EntityFountainJetFX(5, world, (double)pos.getX() + 0.5, (double)pos.getY() + 1.1, (double)pos.getZ() + 0.5, block);
            this.addEffect(effect);
        }
    }

    public static class Dust
    extends JetEffect {
        public Dust(int chance) {
            super(chance);
        }

        @Override
        public boolean trigger(Block block, World world, BlockPos pos, Random random) {
            return super.trigger(block, world, pos, random) && world.func_147437_c(pos.getX(), pos.getY() - 1, pos.getZ());
        }

        @Override
        public void doEffect(Block block, World world, BlockPos pos, Random random) {
            EntityDustJetFX effect = new EntityDustJetFX(2, world, (double)pos.getX() + 0.5, (double)pos.getY() - 0.2, (double)pos.getZ() + 0.5, block);
            this.addEffect(effect);
        }
    }

    public static class Steam
    extends JetEffect {
        public Steam(int chance) {
            super(chance);
        }

        protected int lavaCount(World world, BlockPos pos) {
            int blockCount = 0;
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    for (int k = -1; k <= 1; ++k) {
                        if (world.func_147439_a(pos.getX() + i, pos.getY() + j, pos.getZ() + k) != Blocks.field_150353_l) continue;
                        ++blockCount;
                    }
                }
            }
            return blockCount;
        }

        @Override
        public boolean trigger(Block block, World world, BlockPos pos, Random random) {
            if (!super.trigger(block, world, pos, random) || !world.func_147437_c(pos.getX(), pos.getY() + 1, pos.getZ())) {
                return false;
            }
            return this.lavaCount(world, pos) != 0;
        }

        @Override
        public void doEffect(Block block, World world, BlockPos pos, Random random) {
            int strength = this.lavaCount(world, pos);
            double spawnHeight = JetEffect.jetSpawnHeight(world, pos);
            EntitySteamJetFX effect = new EntitySteamJetFX(strength, world, (double)pos.getX() + 0.5, spawnHeight, (double)pos.getZ() + 0.5);
            this.addEffect(effect);
        }
    }

    public static class Bubble
    extends JetEffect {
        public Bubble(int chance) {
            super(chance);
        }

        @Override
        public boolean trigger(Block block, World world, BlockPos pos, Random random) {
            return super.trigger(block, world, pos, random) && world.func_147439_a(pos.getX(), pos.getY() - 1, pos.getZ()).func_149688_o().func_76220_a();
        }

        @Override
        public void doEffect(Block block, World world, BlockPos pos, Random random) {
            int waterBlocks = JetEffect.countBlocks(world, pos, block, 1);
            EntityBubbleJetFX effect = new EntityBubbleJetFX(waterBlocks, world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5);
            this.addEffect(effect);
        }
    }

    public static class Fire
    extends JetEffect {
        public Fire(int chance) {
            super(chance);
        }

        @Override
        public boolean trigger(Block block, World world, BlockPos pos, Random random) {
            return super.trigger(block, world, pos, random) && world.func_147437_c(pos.getX(), pos.getY() + 1, pos.getZ());
        }

        @Override
        public void doEffect(Block block, World world, BlockPos pos, Random random) {
            int lavaBlocks = JetEffect.countBlocks(world, pos, block, -1);
            double spawnHeight = JetEffect.jetSpawnHeight(world, pos);
            EntityFireJetFX effect = new EntityFireJetFX(lavaBlocks, world, (double)pos.getX() + 0.5, spawnHeight, (double)pos.getZ() + 0.5);
            this.addEffect(effect);
        }
    }
}

