/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client.footsteps.game.system;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.ResourcePackRepository;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.IMetadataSerializer;
import net.minecraft.util.ResourceLocation;
import org.blockartistry.mod.DynSurround.ModLog;
import org.blockartistry.mod.DynSurround.Module;

@SideOnly(value=Side.CLIENT)
public class PFResourcePackDealer {
    private final ResourceLocation pf_pack = new ResourceLocation("footsteps", "pf_pack.json");
    private final ResourceLocation acoustics = new ResourceLocation("footsteps", "acoustics.json");
    private final ResourceLocation blockmap = new ResourceLocation("footsteps", "blockmap.json");
    private final ResourceLocation primitivemap = new ResourceLocation("footsteps", "primitivemap.json");
    private final ResourceLocation variator = new ResourceLocation("footsteps", "variator.json");

    public List<IResourcePack> findResourcePacks() {
        List repo = Minecraft.func_71410_x().func_110438_M().func_110613_c();
        ArrayList<IResourcePack> foundEntries = new ArrayList<IResourcePack>();
        foundEntries.add(new DefaultPack());
        for (ModContainer mod : Loader.instance().getActiveModList()) {
            foundEntries.add(new DefaultPack(mod.getModId()));
        }
        for (ResourcePackRepository.Entry pack : repo) {
            ModLog.debug("Resource Pack: %s", pack.func_110515_d());
            if (!this.checkCompatible(pack)) continue;
            ModLog.debug("Found Footsteps resource pack: %s", pack.func_110515_d());
            foundEntries.add(pack.func_110514_c());
        }
        return foundEntries;
    }

    private boolean checkCompatible(ResourcePackRepository.Entry pack) {
        return pack.func_110514_c().func_110589_b(this.pf_pack);
    }

    public InputStream openPackDescriptor(IResourcePack pack) throws IOException {
        return pack.func_110590_a(this.pf_pack);
    }

    public InputStream openAcoustics(IResourcePack pack) throws IOException {
        return pack.func_110590_a(this.acoustics);
    }

    public InputStream openBlockMap(IResourcePack pack) throws IOException {
        return pack.func_110590_a(this.blockmap);
    }

    public InputStream openPrimitiveMap(IResourcePack pack) throws IOException {
        return pack.func_110590_a(this.primitivemap);
    }

    public InputStream openVariator(IResourcePack pack) throws IOException {
        return pack.func_110590_a(this.variator);
    }

    private static class DefaultPack
    implements IResourcePack {
        private final String mod;

        public DefaultPack() {
            this.mod = null;
        }

        public DefaultPack(String mod) {
            this.mod = mod;
        }

        public InputStream func_110590_a(ResourceLocation loc) throws IOException {
            StringBuilder builder = new StringBuilder();
            builder.append("/assets/dsurround/data/");
            builder.append(loc.func_110624_b());
            builder.append('/');
            if (this.mod != null) {
                builder.append(this.mod).append('_');
            }
            builder.append(loc.func_110623_a());
            return Module.class.getResourceAsStream(builder.toString());
        }

        public boolean func_110589_b(ResourceLocation loc) {
            return true;
        }

        public Set<String> func_110587_b() {
            return null;
        }

        public IMetadataSection func_135058_a(IMetadataSerializer loc, String data) throws IOException {
            return null;
        }

        public BufferedImage func_110586_a() throws IOException {
            return null;
        }

        public String func_130077_b() {
            if (this.mod == null) {
                return "DEFAULT";
            }
            return "DEFAULT: " + this.mod;
        }
    }
}

