/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client.footsteps.engine.implem;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.blockartistry.mod.DynSurround.ModLog;
import org.blockartistry.mod.DynSurround.client.footsteps.engine.interfaces.EventType;
import org.blockartistry.mod.DynSurround.client.footsteps.engine.interfaces.IAcoustic;
import org.blockartistry.mod.DynSurround.client.footsteps.engine.interfaces.ILibrary;
import org.blockartistry.mod.DynSurround.client.footsteps.engine.interfaces.INamedAcoustic;
import org.blockartistry.mod.DynSurround.client.footsteps.engine.interfaces.IOptions;
import org.blockartistry.mod.DynSurround.client.footsteps.engine.interfaces.ISoundPlayer;
import org.blockartistry.mod.DynSurround.client.footsteps.game.system.Association;

@SideOnly(value=Side.CLIENT)
public abstract class AcousticsLibrary
implements ILibrary {
    private final Map<String, IAcoustic> acoustics = new LinkedHashMap<String, IAcoustic>();

    @Override
    public void addAcoustic(INamedAcoustic acoustic) {
        this.acoustics.put(acoustic.getName(), acoustic);
    }

    @Override
    public void playAcoustic(Object location, Association acousticName, EventType event) {
        this.playAcoustic(location, acousticName.getData(), event, null);
    }

    @Override
    public void playAcoustic(Object location, String acousticName, EventType event, IOptions inputOptions) {
        String[] fragments;
        if (StringUtils.isEmpty((CharSequence)acousticName)) {
            ModLog.debug("Attempt to play acoustic with no name", new Object[0]);
            return;
        }
        for (String fragment : fragments = acousticName.split(",")) {
            IAcoustic acoustic = this.acoustics.get(fragment);
            if (acoustic == null) {
                this.onAcousticNotFound(location, fragment, event, inputOptions);
                continue;
            }
            if (ModLog.DEBUGGING) {
                ModLog.debug("  Playing acoustic " + acousticName + " for event " + event.toString().toUpperCase(), new Object[0]);
            }
            acoustic.playSound(this.mySoundPlayer(), location, event, inputOptions);
        }
    }

    protected void onAcousticNotFound(Object location, String acousticName, EventType event, IOptions inputOptions) {
        ModLog.debug("Tried to play a missing acoustic: " + acousticName, new Object[0]);
    }

    protected abstract ISoundPlayer mySoundPlayer();
}

