/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client.fog;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import javax.annotation.Nonnull;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import org.blockartistry.mod.DynSurround.ModOptions;
import org.blockartistry.mod.DynSurround.client.EnvironStateHandler;
import org.blockartistry.mod.DynSurround.client.fog.FogResult;
import org.blockartistry.mod.DynSurround.client.fog.VanillaFogRangeCalculator;
import org.blockartistry.mod.DynSurround.util.MathStuff;
import org.blockartistry.mod.DynSurround.util.random.XorShiftRandom;

@SideOnly(value=Side.CLIENT)
public class MorningFogRangeCalculator
extends VanillaFogRangeCalculator {
    protected static final float START = 0.63f;
    protected static final float MID = 0.73f;
    protected static final float END = 0.83f;
    protected static final float RESERVE = 10.0f;
    protected int fogDay = -1;
    protected boolean doFog = false;
    protected final FogResult cache = new FogResult();

    @Override
    @Nonnull
    public FogResult calculate(@Nonnull EntityViewRenderEvent.RenderFogEvent event) {
        float ca;
        this.cache.set(event);
        if (this.doFog && this.cache.getStart() > 10.0f && EnvironStateHandler.EnvironState.getDimensionId() != 1 && EnvironStateHandler.EnvironState.getDimensionId() != -1 && (ca = EnvironStateHandler.EnvironState.getWorld().func_72826_c((float)event.renderPartialTicks)) >= 0.63f && ca <= 0.83f) {
            float factor = 1.0f - MathStuff.abs(ca - 0.73f) / 0.100000024f;
            float shift = this.cache.getStart() * factor;
            float newEnd = this.cache.getEnd() - shift;
            float newStart = MathStuff.clamp(this.cache.getStart() - shift * 2.0f, 11.0f, newEnd);
            this.cache.set(newStart, newEnd);
        }
        return this.cache;
    }

    private int getDay() {
        long time = EnvironStateHandler.EnvironState.getWorld().func_72820_D();
        return (int)(time / 24000L);
    }

    @Override
    public void tick() {
        int day = this.getDay();
        if (this.fogDay != day) {
            this.fogDay = day;
            this.doFog = ModOptions.morningFogChance < 2 || XorShiftRandom.current().nextInt(ModOptions.morningFogChance) == 0;
        }
    }
}

