/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client.aurora;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import org.blockartistry.mod.DynSurround.ModOptions;
import org.blockartistry.mod.DynSurround.client.aurora.Node;
import org.blockartistry.mod.DynSurround.data.AuroraData;
import org.blockartistry.mod.DynSurround.data.AuroraPreset;
import org.blockartistry.mod.DynSurround.data.ColorPair;
import org.blockartistry.mod.DynSurround.util.Color;
import org.blockartistry.mod.DynSurround.util.MathStuff;
import org.blockartistry.mod.DynSurround.util.random.XorShiftRandom;

@SideOnly(value=Side.CLIENT)
public final class Aurora {
    private static final float ANGLE1 = 0.19634955f;
    private static final float ANGLE2 = MathStuff.toRadians(12.857142f);
    private static final int FADE_LIMIT = 1280;
    private static final float AURORA_SPEED = 0.75f;
    private static final float AURORA_AMPLITUDE = 18.0f;
    private static final float AURORA_WAVELENGTH = 8.0f;
    public float posX;
    public float posZ;
    private Node[][] bands;
    private final long seed;
    private float cycle = 0.0f;
    private int fadeTimer = 0;
    private boolean isAlive = true;
    private int length;
    private float nodeLength;
    private float nodeWidth;
    private int bandOffset;
    private final Color baseColor;
    private final Color fadeColor;
    private int alpha = 1;

    public Aurora(AuroraData data) {
        this(data.posX, data.posZ, data.seed, data.colorSet, data.preset);
    }

    public Aurora(float x, float z, long seed, int colorConfig, int presetConfig) {
        this.seed = seed;
        this.posX = x;
        this.posZ = z;
        ColorPair pair = ColorPair.get(colorConfig);
        this.baseColor = pair.baseColor;
        this.fadeColor = pair.fadeColor;
        this.preset(presetConfig);
        this.generateBands();
        this.translate(0.0f);
    }

    public Node[][] getNodeList() {
        return this.bands;
    }

    private void preset(int preset) {
        AuroraPreset p = AuroraPreset.get(preset);
        this.length = p.length;
        this.nodeLength = p.nodeLength;
        this.nodeWidth = p.nodeWidth;
        this.bandOffset = p.bandOffset;
    }

    public Color getBaseColor() {
        return this.baseColor;
    }

    public Color getFadeColor() {
        return this.fadeColor;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public void die() {
        if (this.isAlive) {
            this.isAlive = false;
            this.fadeTimer = 0;
        }
    }

    public void update() {
        float f;
        if (this.fadeTimer < 1280) {
            if (this.fadeTimer % 10 == 0 && this.alpha > 0) {
                this.alpha += this.isAlive ? 1 : -1;
            }
            ++this.fadeTimer;
        }
        this.cycle += 0.75f;
        if (f >= 360.0f) {
            this.cycle -= 360.0f;
        }
    }

    private void generateBands() {
        Node[] band2;
        Node[] band1;
        this.bands = new Node[ModOptions.auroraMultipleBands ? 3 : 1][];
        this.bands[0] = this.populate();
        Node[] band0 = this.bands[0];
        if (this.bands.length > 1) {
            this.bands[1] = Aurora.populateFromTemplate(this.bands[0], this.bandOffset);
            band1 = this.bands[1];
            this.bands[2] = Aurora.populateFromTemplate(this.bands[0], -this.bandOffset);
            band2 = this.bands[2];
        } else {
            band2 = null;
            band1 = null;
        }
        float factor = (float)Math.PI / (float)(this.length / 4);
        int lowerBound = this.length / 8 + 1;
        int upperBound = this.length * 7 / 8 - 1;
        int count = 0;
        for (int i = 0; i < this.length; ++i) {
            float width = i < lowerBound ? MathStuff.sin(factor * (float)count++) * this.nodeWidth : (i > upperBound ? MathStuff.sin(factor * (float)count--) * this.nodeWidth : this.nodeWidth);
            band0[i].setWidth(width);
            if (band1 == null) continue;
            band1[i].setWidth(width);
            band2[i].setWidth(width);
        }
    }

    private static Node[] populateFromTemplate(Node[] template, int offset) {
        Node[] tet = new Node[template.length];
        for (int i = 0; i < template.length; ++i) {
            tet[i] = new Node(template[i], offset);
        }
        return tet;
    }

    private Node[] populate() {
        float angle;
        Node[] nodeList = new Node[this.length];
        XorShiftRandom nodeRand = new XorShiftRandom(this.seed);
        int bound = this.length / 2 - 1;
        float angleTotal = 0.0f;
        for (int i = this.length / 8 / 2 - 1; i >= 0; --i) {
            angle = (nodeRand.nextFloat() - 0.5f) * 8.0f;
            if (MathStuff.abs(angleTotal += angle) > 180.0f) {
                angle = -angle;
                angleTotal += angle;
            }
            for (int k = 7; k >= 0; --k) {
                int idx = i * 8 + k;
                if (idx == bound) {
                    nodeList[idx] = new Node(0.0f, 7.0f + nodeRand.nextFloat(), 0.0f, angle);
                    continue;
                }
                float y = i == 0 ? MathStuff.sin(0.19634955f * (float)k) * 7.0f + nodeRand.nextFloat() / 2.0f : 10.0f + nodeRand.nextFloat() * 5.0f;
                Node node = nodeList[idx + 1];
                float subAngle = node.angle + angle;
                float subAngleRads = MathStuff.toRadians(subAngle);
                float z = node.posZ - MathStuff.sin(subAngleRads) * this.nodeLength;
                float x = node.posX - MathStuff.cos(subAngleRads) * this.nodeLength;
                nodeList[idx] = new Node(x, y, z, subAngle);
            }
        }
        angleTotal = 0.0f;
        for (int j = this.length / 8 / 2; j < this.length / 8; ++j) {
            angle = (nodeRand.nextFloat() - 0.5f) * 8.0f;
            if (MathStuff.abs(angleTotal += angle) > 180.0f) {
                angle = -angle;
                angleTotal += angle;
            }
            for (int h = 0; h < 8; ++h) {
                float y = j == this.length / 8 - 1 ? MathStuff.cos(ANGLE2 * (float)h) * 7.0f + nodeRand.nextFloat() / 2.0f : 10.0f + nodeRand.nextFloat() * 5.0f;
                Node node = nodeList[j * 8 + h - 1];
                float subAngle = node.angle + angle;
                float subAngleRads = MathStuff.toRadians(subAngle);
                float z = node.posZ + MathStuff.sin(subAngleRads) * this.nodeLength;
                float x = node.posX + MathStuff.cos(subAngleRads) * this.nodeLength;
                nodeList[j * 8 + h] = new Node(x, y, z, subAngle);
            }
        }
        return nodeList;
    }

    public void translate(float partialTick) {
        Node[] nodeList = this.bands[0];
        Node[] second = null;
        Node[] third = null;
        if (this.bands.length > 1) {
            second = this.bands[1];
            third = this.bands[2];
        }
        float c = this.cycle + 0.75f * partialTick;
        for (int i = 0; i < nodeList.length; ++i) {
            float f = MathStuff.cos(MathStuff.toRadians(8.0f * (float)i + c));
            float dZ = f * 18.0f;
            float dY = f * 3.0f;
            Node node = nodeList[i];
            node.setDeltaZ(dZ);
            node.setDeltaY(dY);
            if (second == null) continue;
            node = second[i];
            node.setDeltaZ(dZ);
            node.setDeltaY(dY);
            node = third[i];
            node.setDeltaZ(dZ);
            node.setDeltaY(dY);
        }
        Aurora.findAngles(nodeList);
        if (second != null) {
            Aurora.findAngles(second);
            Aurora.findAngles(third);
        }
    }

    private static void findAngles(Node[] nodeList) {
        nodeList[0].findAngles(null);
        for (int i = 1; i < nodeList.length - 1; ++i) {
            nodeList[i].findAngles(nodeList[i + 1]);
        }
        nodeList[nodeList.length - 1].findAngles(null);
    }
}

