/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import org.blockartistry.mod.DynSurround.ModLog;
import org.blockartistry.mod.DynSurround.ModOptions;
import org.blockartistry.mod.DynSurround.client.EnvironStateHandler;
import org.blockartistry.mod.DynSurround.client.IClientEffectHandler;
import org.blockartistry.mod.DynSurround.client.aurora.Aurora;
import org.blockartistry.mod.DynSurround.data.AuroraData;
import org.blockartistry.mod.DynSurround.util.DiurnalUtils;

@SideOnly(value=Side.CLIENT)
public final class AuroraEffectHandler
implements IClientEffectHandler {
    private static int auroraDimension = 0;
    private static final Set<AuroraData> auroras = new HashSet<AuroraData>();
    public static Aurora currentAurora;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAurora(AuroraData data) {
        if (!ModOptions.auroraEnable) {
            return;
        }
        Set<AuroraData> set = auroras;
        synchronized (set) {
            if (auroraDimension != data.dimensionId || EnvironStateHandler.EnvironState.getDimensionId() != data.dimensionId) {
                auroras.clear();
                currentAurora = null;
                auroraDimension = data.dimensionId;
            }
            auroras.add(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Aurora getClosestAurora(World world) {
        AuroraData ad = null;
        Set<AuroraData> set = auroras;
        synchronized (set) {
            if (auroraDimension != EnvironStateHandler.EnvironState.getDimensionId() || DiurnalUtils.isDaytime(world)) {
                auroras.clear();
            }
            if (auroras.size() == 0) {
                currentAurora = null;
                return null;
            }
            EntityPlayer player = EnvironStateHandler.EnvironState.getPlayer();
            int playerX = (int)player.field_70165_t;
            int playerZ = (int)player.field_70161_v;
            boolean started = false;
            int distanceSq = 0;
            for (AuroraData data : auroras) {
                int deltaX = data.posX - playerX;
                int deltaZ = data.posZ - playerZ;
                int d = deltaX * deltaX + deltaZ * deltaZ;
                if (started && distanceSq <= d) continue;
                started = true;
                distanceSq = d;
                ad = data;
            }
        }
        if (ad == null) {
            currentAurora = null;
        } else if (currentAurora == null || AuroraEffectHandler.currentAurora.posX != (float)ad.posX && AuroraEffectHandler.currentAurora.posZ != (float)ad.posZ) {
            ModLog.debug("New aurora: " + ad, new Object[0]);
            currentAurora = new Aurora(ad);
        }
        return currentAurora;
    }

    @Override
    public boolean hasEvents() {
        return false;
    }

    @Override
    public void process(World world, EntityPlayer player) {
        Aurora aurora = this.getClosestAurora(world);
        if (aurora != null) {
            aurora.update();
            if (aurora.isAlive() && DiurnalUtils.isSunrise(world)) {
                ModLog.debug("Aurora fade...", new Object[0]);
                aurora.die();
            }
        }
    }
}

