/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import org.apache.commons.lang3.StringUtils;
import org.blockartistry.mod.DynSurround.ModLog;
import org.blockartistry.mod.DynSurround.ModOptions;

public final class VersionCheck
implements Runnable {
    private static final String REMOTE_VERSION_FILE = "https://raw.githubusercontent.com/mist475/DynamicSurroundings/master/versions.txt";
    private static final int VERSION_CHECK_RETRIES = 3;
    private static final int VERSION_CHECK_INTERVAL = 10000;
    public static final SoftwareVersion modVersion = new SoftwareVersion("1.0.7.7");
    public static SoftwareVersion currentVersion = new SoftwareVersion();
    public static UpdateStatus status = UpdateStatus.UNKNOWN;
    private static final String mcVersion = Loader.instance().getMinecraftModContainer().getVersion();
    public static VersionCheck instance;

    private VersionCheck() {
    }

    public static void register() {
        if (ModOptions.enableVersionChecking) {
            instance = new VersionCheck();
            MinecraftForge.EVENT_BUS.register((Object)instance);
            new Thread(instance).start();
        }
    }

    @SubscribeEvent
    public void playerLogin(EntityJoinWorldEvent event) {
        Entity entity = event.entity;
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (status == UpdateStatus.OUTDATED) {
                String msg = StatCollector.func_74837_a((String)"msg.NewVersionAvailable.dsurround", (Object[])new Object[]{"Dynamic Surroundings", currentVersion});
                IChatComponent component = IChatComponent.Serializer.func_150699_a((String)msg);
                player.func_145747_a(component);
            }
            MinecraftForge.EVENT_BUS.unregister((Object)instance);
        }
    }

    private static void versionCheck() {
        try {
            String line;
            URL url = new URL(REMOTE_VERSION_FILE);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            if (conn == null) {
                throw new NullPointerException();
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = reader.readLine()) != null) {
                String[] tokens = line.split(":");
                if (!mcVersion.matches(tokens[0])) continue;
                currentVersion = new SoftwareVersion(tokens[1]);
                break;
            }
            status = UpdateStatus.CURRENT;
            if (modVersion.compareTo(currentVersion) < 0) {
                status = UpdateStatus.OUTDATED;
            }
            conn.disconnect();
            reader.close();
        }
        catch (Exception e) {
            ModLog.warn("Unable to read remote version data", e);
            status = UpdateStatus.COMM_ERROR;
        }
    }

    @Override
    public void run() {
        int count = 0;
        ModLog.info("Checking for newer mod version", new Object[0]);
        try {
            do {
                if (count > 0) {
                    ModLog.info("Awaiting attempt %d", count);
                    Thread.sleep(10000L);
                }
                VersionCheck.versionCheck();
            } while (++count < 3 && status == UpdateStatus.COMM_ERROR);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        switch (status) {
            case COMM_ERROR: {
                ModLog.warn("Version check failed", new Object[0]);
                break;
            }
            case CURRENT: {
                ModLog.info("Dynamic Surroundings version [%s] is the same or newer than the current version [%s]", modVersion, currentVersion);
                break;
            }
            case OUTDATED: {
                ModLog.warn("Using outdated version [" + modVersion + "] for Minecraft " + mcVersion + ". Consider updating to " + currentVersion + ".", new Object[0]);
                break;
            }
            case UNKNOWN: {
                ModLog.warn("Unknown version check status!", new Object[0]);
                break;
            }
        }
    }

    public static enum UpdateStatus {
        UNKNOWN,
        CURRENT,
        OUTDATED,
        COMM_ERROR;

    }

    public static class SoftwareVersion
    implements Comparable<SoftwareVersion> {
        public final int major;
        public final int minor;
        public final int revision;
        public final int patch;
        public final boolean isAlpha;
        public final boolean isBeta;

        public SoftwareVersion() {
            this.major = 0;
            this.minor = 0;
            this.revision = 0;
            this.patch = 0;
            this.isAlpha = false;
            this.isBeta = false;
        }

        public SoftwareVersion(String versionString) {
            Pattern pattern;
            Matcher matcher;
            if (versionString.charAt(0) == 'v') {
                versionString = versionString.substring(1);
            }
            versionString = StringUtils.remove((String)versionString, (String)".dirty");
            assert (versionString.length() > 0);
            this.isAlpha = StringUtils.containsIgnoreCase((CharSequence)versionString, (CharSequence)"ALPHA");
            if (this.isAlpha) {
                versionString = StringUtils.remove((String)versionString, (String)"ALPHA");
            }
            this.isBeta = StringUtils.containsIgnoreCase((CharSequence)versionString, (CharSequence)"BETA");
            if (this.isBeta) {
                versionString = StringUtils.remove((String)versionString, (String)"BETA");
            }
            String[] parts = StringUtils.split((String)versionString, (String)".");
            int numComponents = parts.length;
            assert (numComponents >= 3);
            this.major = Integer.parseInt(parts[0]);
            this.minor = Integer.parseInt(parts[1]);
            this.revision = Integer.parseInt(parts[2]);
            if (numComponents == 4 && (matcher = (pattern = Pattern.compile("\\d+")).matcher(parts[3])).find()) {
                String matches = matcher.group(0);
                this.patch = Integer.parseInt(matches);
                return;
            }
            this.patch = 0;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.major).append('.').append(this.minor).append('.').append(this.revision);
            if (this.patch != 0) {
                builder.append('.').append(this.patch);
            }
            if (this.isAlpha) {
                builder.append("ALPHA");
            }
            if (this.isBeta) {
                builder.append("BETA");
            }
            return builder.toString();
        }

        @Override
        public int compareTo(SoftwareVersion obj) {
            if (this.major != obj.major) {
                return this.major - obj.major;
            }
            if (this.minor != obj.minor) {
                return this.minor - obj.minor;
            }
            if (this.revision != obj.revision) {
                return this.revision - obj.revision;
            }
            return this.patch - obj.patch;
        }
    }
}

