/*
 * Decompiled with CFR 0.152.
 */
package covers1624.powerconverters;

import covers1624.powerconverters.grid.GridTickHandler;
import covers1624.powerconverters.handler.ConfigurationHandler;
import covers1624.powerconverters.handler.PCEventHandler;
import covers1624.powerconverters.handler.PCGUIHandler;
import covers1624.powerconverters.init.ModBlocks;
import covers1624.powerconverters.init.ModItems;
import covers1624.powerconverters.init.PowerSystems;
import covers1624.powerconverters.init.Recipes;
import covers1624.powerconverters.init.WorldGenerators;
import covers1624.powerconverters.net.EnergyBridgeSyncPacket;
import covers1624.powerconverters.net.PacketPipeline;
import covers1624.powerconverters.net.RecipeSyncPacket;
import covers1624.powerconverters.proxy.IPCProxy;
import covers1624.powerconverters.updatechecker.UpdateManager;
import covers1624.powerconverters.util.LogHelper;
import covers1624.powerconverters.util.RFHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidRegistry;

@Mod(modid="PowerConverters3", name="Power Converters 3", version="1.7.10-2.11", dependencies="after:BuildCraft|Energy;after:factorization;after:IC2;after:Railcraft;after:ThermalExpansion", guiFactory="covers1624.powerconverters.gui.PCGuiFactory")
public class PowerConverters {
    @SidedProxy(clientSide="covers1624.powerconverters.proxy.ProxyClient", serverSide="covers1624.powerconverters.proxy.ProxyServer")
    public static IPCProxy proxy;
    @Mod.Instance(value="Power Converters")
    public static PowerConverters instance;
    private static ConfigurationHandler configHandler;
    public static int steamId;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        PowerConverters.checkClassLoader();
        instance = this;
        LogHelper.info("PowerConverters PreInitialization Started.");
        LogHelper.trace("Checking For RF API...");
        RFHelper.init();
        LogHelper.trace("Initializing Configuration File");
        configHandler = new ConfigurationHandler(event.getSuggestedConfigurationFile());
        LogHelper.trace("Registering Update Manager");
        UpdateManager updateManager = new UpdateManager();
        FMLCommonHandler.instance().bus().register((Object)updateManager);
        LogHelper.trace("Registering Event Handlers.");
        PCEventHandler eventHandler = new PCEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        FMLCommonHandler.instance().bus().register((Object)eventHandler);
        LogHelper.trace("Initializing PowerSystems");
        PowerSystems.init();
        LogHelper.trace("Initializing ChargeHandlers");
        PowerSystems.initChargeHandlers();
        LogHelper.info("PowerConverters PreInitialization Finished.");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        LogHelper.info("PowerConverters Core Initialization Started.");
        LogHelper.trace("Initializing PacketPipeline");
        PacketPipeline.INSTANCE.initalise();
        PacketPipeline.INSTANCE.registerPacket(RecipeSyncPacket.class);
        PacketPipeline.INSTANCE.registerPacket(EnergyBridgeSyncPacket.class);
        MinecraftForge.EVENT_BUS.register(GridTickHandler.energy);
        FMLCommonHandler.instance().bus().register(GridTickHandler.energy);
        LogHelper.trace("Registering Gui Handler.");
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new PCGUIHandler());
        LogHelper.trace("Registering Blocks.");
        ModBlocks.init();
        LogHelper.trace("Registering Items.");
        ModItems.init();
        LogHelper.trace("Registering World Generators.");
        WorldGenerators.init();
        LogHelper.trace("Registering Client Rendering.");
        proxy.initRendering();
        if (!ConfigurationHandler.useTechRebornRecipes && !ConfigurationHandler.useThermalExpansionRecipes) {
            LogHelper.trace("Registering Default Recipes.");
            Recipes.initDefaults();
        }
        Recipes.setDefaultRecipes(Recipes.getCurrentRecipes());
        if (Loader.isModLoaded((String)"Waila")) {
            LogHelper.trace("Regestering Waila Module.");
            FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"covers1624.powerconverters.waila.WailaModule.callBackRegister");
        }
        LogHelper.info("PowerConverters Core Initialization Finished.");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        LogHelper.info("PowerConverters PostInitialization Started.");
        LogHelper.trace("PostInitializing PacketPipeline. ALL PACKETS SHOULD BE REGISTERED BY NOW!");
        PacketPipeline.INSTANCE.postInitialise();
        if (FluidRegistry.isFluidRegistered((String)"steam")) {
            steamId = FluidRegistry.getFluidID((String)"steam");
        }
        LogHelper.trace("PowerConverters PostInitialization Finished.");
    }

    @Mod.EventHandler
    public void missingMapping(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.getAll()) {
            if (mapping.type == GameRegistry.Type.BLOCK) {
                if (mapping.name.equals("PowerConverters:tile.powerconverters.conduit")) {
                    LogHelper.warn("REMAPPING BLOCK: " + mapping.name);
                    mapping.remap(ModBlocks.conduitBlock);
                }
                if (mapping.name.equals("PowerConverters:tile.powerconverters.rf")) {
                    LogHelper.warn("REMAPPING BLOCK: " + mapping.name);
                    mapping.remap(ModBlocks.converterBlockRedstoneFlux);
                }
                if (mapping.name.equals("PowerConverters:tile.powerconverters.ic2")) {
                    LogHelper.warn("REMAPPING BLOCK: " + mapping.name);
                    mapping.remap(ModBlocks.converterBlockIndustrialCraft);
                }
                if (mapping.name.equals("PowerConverters:tile.powerconverters.fz")) {
                    LogHelper.warn("REMAPPING BLOCK: " + mapping.name);
                    mapping.remap(ModBlocks.converterBlockFactorization);
                }
                if (mapping.name.equals("PowerConverters:tile.powerconverters.steam")) {
                    LogHelper.warn("REMAPPING BLOCK: " + mapping.name);
                    mapping.remap(ModBlocks.converterBlockSteam);
                }
                if (mapping.name.equals("PowerConverters:tile.powerconverters.common")) {
                    LogHelper.warn("REMAPPING BLOCK: " + mapping.name);
                    mapping.remap(ModBlocks.converterBlockCommon);
                }
            }
            if (mapping.type != GameRegistry.Type.ITEM) continue;
            if (mapping.name.equals("PowerConverters:debugItem")) {
                LogHelper.warn("REMAPPING ITEM: " + mapping.name);
                mapping.remap(ModItems.debugItem);
            }
            if (mapping.name.equals("PowerConverters:tile.powerconverters.conduit")) {
                LogHelper.warn("REMAPPING ITEM: " + mapping.name);
                mapping.remap(Item.func_150898_a((Block)ModBlocks.conduitBlock));
            }
            if (mapping.name.equals("PowerConverters:tile.powerconverters.rf")) {
                LogHelper.warn("REMAPPING ITEM: " + mapping.name);
                mapping.remap(Item.func_150898_a((Block)ModBlocks.converterBlockRedstoneFlux));
            }
            if (mapping.name.equals("PowerConverters:tile.powerconverters.ic2")) {
                LogHelper.warn("REMAPPING ITEM: " + mapping.name);
                mapping.remap(Item.func_150898_a((Block)ModBlocks.converterBlockIndustrialCraft));
            }
            if (mapping.name.equals("PowerConverters:tile.powerconverters.fz")) {
                LogHelper.warn("REMAPPING ITEM: " + mapping.name);
                mapping.remap(Item.func_150898_a((Block)ModBlocks.converterBlockFactorization));
            }
            if (mapping.name.equals("PowerConverters:tile.powerconverters.steam")) {
                LogHelper.warn("REMAPPING ITEM: " + mapping.name);
                mapping.remap(Item.func_150898_a((Block)ModBlocks.converterBlockSteam));
            }
            if (!mapping.name.equals("PowerConverters:tile.powerconverters.common")) continue;
            LogHelper.warn("REMAPPING ITEM: " + mapping.name);
            mapping.remap(Item.func_150898_a((Block)ModBlocks.converterBlockCommon));
        }
    }

    private static void checkClassLoader() {
        Set transformerExceptions = (Set)ReflectionHelper.getPrivateValue(LaunchClassLoader.class, (Object)Launch.classLoader, (String[])new String[]{"transformerExceptions"});
        if (!transformerExceptions.contains("covers1624.powerconverters.")) {
            LogHelper.fatal("PowerConverters has detected that it has been removed from the transformerExceptions list, this could cause unknown issues. I Will provide no support for PowerConverters in this state.");
        }
    }

    static {
        steamId = -1;
    }
}

