/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.mcpatcher.internal.modules.ctm;

import com.falsepattern.mcpatcher.internal.modules.ctm.Axis;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;

public enum Side {
    YNeg(Axis.Y),
    YPos(Axis.Y),
    ZNeg(Axis.Z),
    ZPos(Axis.Z),
    XNeg(Axis.X),
    XPos(Axis.X);

    public static final Side Bottom;
    public static final Side Top;
    public static final Side North;
    public static final Side South;
    public static final Side West;
    public static final Side East;
    public static final int MASK_SIDES;
    public static final int MASK_ALL;
    public static final int MASK_UNKNOWN = 128;
    private static final Side[] BY_INDEX;
    public final int mask = 1 << this.ordinal();
    public final Axis axis;

    public static boolean matches(int mask, int value) {
        return (value & mask) == mask;
    }

    @Nullable
    public static Side fromMCDirection(int direction) {
        if (direction < 0 || direction >= BY_INDEX.length) {
            return null;
        }
        return BY_INDEX[direction];
    }

    public boolean matches(int value) {
        return Side.matches(this.mask, value);
    }

    @Generated
    private Side(Axis axis) {
        this.axis = axis;
    }

    static {
        Bottom = YNeg;
        Top = YPos;
        North = ZNeg;
        South = ZPos;
        West = XNeg;
        East = XPos;
        MASK_SIDES = Side.ZNeg.mask | Side.ZPos.mask | Side.XNeg.mask | Side.XPos.mask;
        MASK_ALL = MASK_SIDES | Side.YNeg.mask | Side.YPos.mask;
        BY_INDEX = Side.values();
    }
}

