/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.mcpatcher.internal.modules.ctm;

import com.falsepattern.mcpatcher.internal.modules.ctm.CTMInfo;
import com.falsepattern.mcpatcher.internal.modules.overlay.ResourceGenerator;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.imageio.ImageIO;
import lombok.Generated;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompactCTMDecoder {
    private static final int[] UNCOMPACTION_TABLE;

    @Nullable
    public static IIcon[] decode(@NotNull ObjectList<String> tileNames, @NotNull TextureMap textureMap, @NotNull Map<ResourceLocation, ResourceGenerator> overlay) {
        assert (tileNames.size() == 5);
        ResourceLocation[] base = new ResourceLocation[5];
        for (int i = 0; i < 5; ++i) {
            String iconName = (String)tileNames.get(i);
            String fileName = CTMInfo.toFileName(iconName);
            base[i] = new ResourceLocation(fileName);
        }
        BufferedImage[] imgs = new BufferedImage[5];
        IIcon[] icons = new IIcon[47];
        for (int i = 0; i < 47; ++i) {
            String iconName = (String)tileNames.get(0) + "$$GEN" + i;
            String fileName = CTMInfo.toFileName(iconName);
            CompositeTextureIcon iconGen = new CompositeTextureIcon(base, imgs, i);
            overlay.put(new ResourceLocation(fileName), iconGen);
            icons[i] = textureMap.func_94245_a(iconName);
        }
        return icons;
    }

    static {
        String lutString = "abcd ancp mnop mbod ankt mbsl irkt mnst qfst qrsh ergt efst abkl ankh mngh mbgl ircp qjod qrop qjsl erst qrgt qrgh qfsh ijkl ifkh efgh ejgl irkh mngt ifkt mnsh efgt efsh qfgt ersh ijcd ifcp efop ejod qfop ejsl erop qjgl ergh qfgh qrst";
        int[] output = new int[47];
        for (int i = 0; i < 47; ++i) {
            int packed;
            int offset = i * 5;
            int tl = "abcd ancp mnop mbod ankt mbsl irkt mnst qfst qrsh ergt efst abkl ankh mngh mbgl ircp qjod qrop qjsl erst qrgt qrgh qfsh ijkl ifkh efgh ejgl irkh mngt ifkt mnsh efgt efsh qfgt ersh ijcd ifcp efop ejod qfop ejsl erop qjgl ergh qfgh qrst".charAt(offset) - 97;
            int tr = "abcd ancp mnop mbod ankt mbsl irkt mnst qfst qrsh ergt efst abkl ankh mngh mbgl ircp qjod qrop qjsl erst qrgt qrgh qfsh ijkl ifkh efgh ejgl irkh mngt ifkt mnsh efgt efsh qfgt ersh ijcd ifcp efop ejod qfop ejsl erop qjgl ergh qfgh qrst".charAt(offset + 1) - 97;
            int bl = "abcd ancp mnop mbod ankt mbsl irkt mnst qfst qrsh ergt efst abkl ankh mngh mbgl ircp qjod qrop qjsl erst qrgt qrgh qfsh ijkl ifkh efgh ejgl irkh mngt ifkt mnsh efgt efsh qfgt ersh ijcd ifcp efop ejod qfop ejsl erop qjgl ergh qfgh qrst".charAt(offset + 2) - 97;
            int br = "abcd ancp mnop mbod ankt mbsl irkt mnst qfst qrsh ergt efst abkl ankh mngh mbgl ircp qjod qrop qjsl erst qrgt qrgh qfsh ijkl ifkh efgh ejgl irkh mngt ifkt mnsh efgt efsh qfgt ersh ijcd ifcp efop ejod qfop ejsl erop qjgl ergh qfgh qrst".charAt(offset + 3) - 97;
            output[i] = packed = tl << 24 | tr << 16 | bl << 8 | br;
        }
        UNCOMPACTION_TABLE = output;
    }

    private static class GeneratedResource
    implements IResource {
        private final byte[] bytes;

        public InputStream func_110527_b() {
            return new ByteArrayInputStream(this.bytes);
        }

        public boolean func_110528_c() {
            return false;
        }

        public IMetadataSection func_110526_a(String sectionName) {
            return null;
        }

        @Generated
        public GeneratedResource(byte[] bytes) {
            this.bytes = bytes;
        }
    }

    private static class CompositeTextureIcon
    implements ResourceGenerator {
        private final ResourceLocation[] base;
        private final BufferedImage[] imgs;
        private final int index;

        @Override
        public IResource gen(IResourceManager manager) throws IOException {
            int w = 0;
            int h = 0;
            for (int i = 0; i < 5; ++i) {
                if (this.imgs[i] == null) {
                    IResource backing = manager.func_110536_a(this.base[i]);
                    this.imgs[i] = ImageIO.read(backing.func_110527_b());
                }
                w = Math.max(w, this.imgs[i].getWidth());
                h = Math.max(h, this.imgs[i].getHeight());
            }
            int dqW = w / 2;
            int dqH = h / 2;
            BufferedImage img = new BufferedImage(w, h, 2);
            Graphics2D gfx = img.createGraphics();
            int lut = UNCOMPACTION_TABLE[this.index];
            for (int i = 0; i < 4; ++i) {
                int lutBits = lut >>> 24 - 8 * i & 0x1F;
                BufferedImage srcImg = this.imgs[Math.min(lutBits >>> 2, 4)];
                int sImgW = srcImg.getWidth();
                int sImgH = srcImg.getHeight();
                int srcQuad = lutBits & 3;
                int sqW = sImgW / 2;
                int sqH = sImgH / 2;
                int sX = sqW * (srcQuad & 1);
                int sY = sqH * (srcQuad >> 1 & 1);
                int dX = dqW * (i & 1);
                int dY = dqH * (i >> 1 & 1);
                gfx.drawImage(srcImg, dX, dY, dX + dqW, dY + dqH, sX, sY, sX + sqW, sY + sqH, null);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, "PNG", out);
            byte[] bytes = out.toByteArray();
            return new GeneratedResource(bytes);
        }

        @Generated
        public CompositeTextureIcon(ResourceLocation[] base, BufferedImage[] imgs, int index) {
            this.base = base;
            this.imgs = imgs;
            this.index = index;
        }
    }
}

